/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.TlsVersion;
import io.grpc.Metadata;
import io.grpc.internal.TransportFrameUtil;
import io.grpc.okhttp.internal.CipherSuite;
import io.grpc.okhttp.internal.ConnectionSpec;
import io.grpc.okhttp.internal.framed.Header;
import java.util.List;

class Utils {
    static final int DEFAULT_WINDOW_SIZE = 65535;
    static final int CONNECTION_STREAM_ID = 0;

    public static Metadata convertHeaders(List<Header> http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Metadata convertTrailers(List<Header> http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(List<Header> http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Header header : http2Headers) {
            headerValues[i++] = header.name.toByteArray();
            headerValues[i++] = header.value.toByteArray();
        }
        return TransportFrameUtil.toRawSerializedHeaders(headerValues);
    }

    static ConnectionSpec convertSpec(com.squareup.okhttp.ConnectionSpec spec) {
        Preconditions.checkArgument((boolean)spec.isTls(), (Object)"plaintext ConnectionSpec is not accepted");
        List tlsVersionList = spec.tlsVersions();
        String[] tlsVersions = new String[tlsVersionList.size()];
        for (int i = 0; i < tlsVersions.length; ++i) {
            tlsVersions[i] = ((TlsVersion)tlsVersionList.get(i)).javaName();
        }
        List cipherSuiteList = spec.cipherSuites();
        CipherSuite[] cipherSuites = new CipherSuite[cipherSuiteList.size()];
        for (int i = 0; i < cipherSuites.length; ++i) {
            cipherSuites[i] = CipherSuite.valueOf(((com.squareup.okhttp.CipherSuite)cipherSuiteList.get(i)).name());
        }
        return new ConnectionSpec.Builder(spec.isTls()).supportsTlsExtensions(spec.supportsTlsExtensions()).tlsVersions(tlsVersions).cipherSuites(cipherSuites).build();
    }

    private Utils() {
    }
}

