/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.JavaDuplocatorSettingsEditor;
import com.intellij.dupLocator.resultUI.BaseDuplicatesView;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.resultUI.MethodBodyType;
import com.intellij.dupLocator.resultUI.TextFragmentType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDuplicatesPresentation
implements DuplicatesPresentation {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesPresentation.class);
    private final JavaLanguage myLanguage = (JavaLanguage)Language.findInstance(JavaLanguage.class);

    @Override
    @NotNull
    public DuplicatesProfile getProfile() {
        DuplicatesProfile duplicatesProfile = DuplicatesProfile.findProfileForLanguage((Language)this.myLanguage);
        if (duplicatesProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getProfile"));
        }
        return duplicatesProfile;
    }

    @Nullable
    private static PsiClass getContainingClass(@NotNull CodeNode node) throws InvalidatedException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getContainingClass"));
        }
        PsiFile file = PsiManager.getInstance((Project)node.getProject()).findFile(node.getVirtualFile());
        if (file == null) {
            return null;
        }
        PsiElement psiElement = file.findElementAt(node.getRangeMarker().getStartOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (psiClass instanceof PsiAnonymousClass) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        }
        return psiClass;
    }

    @Nullable
    public static PsiElement getEnclosingElement(@NotNull CodeNode node) throws InvalidatedException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getEnclosingElement"));
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(node.getRangeMarker().getDocument());
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)node.getProject()).findFile(virtualFile);
        return file != null ? PsiUtil.getElementInclusiveRange((PsiElement)file, (TextRange)node.getTextRange()) : null;
    }

    @Override
    @Nullable
    public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getType"));
        }
        PsiElement element = JavaDuplicatesPresentation.getEnclosingElement(node);
        if (element == null) {
            return null;
        }
        RangeMarker rangeMarker = node.getRangeMarker();
        if (!element.getTextRange().equals((Object)node.getTextRange())) {
            return new TextFragmentType(JavaDuplicatesPresentation.getContainingClass(node), rangeMarker);
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            return new MethodBodyType((PsiMethod)parent);
        }
        return new TextFragmentType(JavaDuplicatesPresentation.getContainingClass(node), rangeMarker);
    }

    @Override
    public boolean isFixAbilityProvided() {
        return true;
    }

    @Override
    public boolean isFixAvailable(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JavaDuplicatesPresentation", "isFixAvailable"));
        }
        try {
            PsiElement enclosingElement = JavaDuplicatesPresentation.getEnclosingElement(node);
            if (enclosingElement != null) {
                ExtractMethodProcessor processor = JavaDuplicatesPresentation.getProcessor(node.getTextRange(), enclosingElement, false);
                if (processor != null) {
                    Set<VirtualFile> files = node.getParent().getAffectedFiles();
                    if (processor.hasDuplicates(files)) {
                        return true;
                    }
                } else {
                    PsiElement element = enclosingElement.getParent();
                    if (element instanceof PsiMethod) {
                        PsiMethod psiMethod = (PsiMethod)element;
                        if (psiMethod.getBody() == null) {
                            return false;
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)node.getProject());
                        Set<VirtualFile> files = node.getParent().getAffectedFiles();
                        for (VirtualFile virtualFile : files) {
                            if (MethodDuplicatesHandler.hasDuplicates((PsiFile)psiManager.findFile(virtualFile), (PsiMember)psiMethod).isEmpty()) continue;
                            return true;
                        }
                    }
                }
            }
        }
        catch (InvalidatedException invalidatedException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void applyFix(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JavaDuplicatesPresentation", "applyFix"));
        }
        try {
            PsiMethod psiMethod;
            Project project = node.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            GroupNode groupNode = node.getParent();
            PsiElement enclosingElement = JavaDuplicatesPresentation.getEnclosingElement(node);
            LOG.assertTrue(enclosingElement != null);
            PsiFile file = enclosingElement.getContainingFile();
            PsiElement parent = enclosingElement.getParent();
            Set<VirtualFile> affectedFiles = groupNode.getAffectedFiles();
            if (parent instanceof PsiMethod) {
                psiMethod = (PsiMethod)parent;
            } else {
                ExtractMethodProcessor processor = JavaDuplicatesPresentation.getProcessor(node.getTextRange(), enclosingElement, true);
                LOG.assertTrue(processor != null);
                if (!ExtractMethodHandler.invokeOnElements((Project)project, (ExtractMethodProcessor)processor, (PsiFile)file, (boolean)false)) {
                    return;
                }
                psiMethod = processor.getExtractedMethod();
                affectedFiles.remove(file.getVirtualFile());
            }
            if (!affectedFiles.isEmpty()) {
                MethodDuplicatesHandler.invokeOnScope((Project)project, (PsiMember)psiMethod, (AnalysisScope)new AnalysisScope(project, affectedFiles));
            }
        }
        catch (InvalidatedException e1) {
            LOG.error((Throwable)e1);
        }
    }

    @Override
    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/JavaDuplicatesPresentation", "createView"));
        }
        BaseDuplicatesView baseDuplicatesView = new BaseDuplicatesView(project);
        if (baseDuplicatesView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaDuplicatesPresentation", "createView"));
        }
        return baseDuplicatesView;
    }

    @Nullable
    private static ExtractMethodProcessor getProcessor(@NotNull TextRange textRange, @NotNull PsiElement enclosingElement, boolean openEditor) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getProcessor"));
        }
        if (enclosingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingElement", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getProcessor"));
        }
        PsiFile file = enclosingElement.getContainingFile();
        PsiElement[] elements = JavaDuplicatesPresentation.getElements(textRange, enclosingElement);
        return ExtractMethodHandler.getProcessor((Project)enclosingElement.getProject(), (PsiElement[])elements, (PsiFile)file, (boolean)openEditor);
    }

    private static PsiElement[] getElements(@NotNull TextRange textRange, @NotNull PsiElement enclosingElement) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getElements"));
        }
        if (enclosingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingElement", "com/intellij/dupLocator/JavaDuplicatesPresentation", "getElements"));
        }
        PsiFile file = enclosingElement.getContainingFile();
        PsiExpression expr = CodeInsightUtil.findExpressionInRange((PsiFile)file, (int)textRange.getStartOffset(), (int)textRange.getEndOffset());
        PsiElement[] elements = expr != null ? new PsiElement[]{expr} : CodeInsightUtil.findStatementsInRange((PsiFile)file, (int)textRange.getStartOffset(), (int)textRange.getEndOffset());
        return elements;
    }

    @Override
    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dupLocator/JavaDuplicatesPresentation", "createEditor"));
        }
        JavaDuplocatorSettingsEditor javaDuplocatorSettingsEditor = new JavaDuplocatorSettingsEditor();
        if (javaDuplocatorSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaDuplicatesPresentation", "createEditor"));
        }
        return javaDuplocatorSettingsEditor;
    }
}

