/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.awt.Color;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class LineChartLegendRenderData
extends LegendRenderData {
    @NotNull
    private final Range myRange;
    @NotNull
    private final RangedContinuousSeries mySeries;
    @NotNull
    private final BaseAxisFormatter myFormatter;

    public LineChartLegendRenderData(@NotNull LegendRenderData.IconType icon, @NotNull Color color, @NotNull Range range, @NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/adtui/LineChartLegendRenderData", "<init>"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/adtui/LineChartLegendRenderData", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/adtui/LineChartLegendRenderData", "<init>"));
        }
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/LineChartLegendRenderData", "<init>"));
        }
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/android/tools/adtui/LineChartLegendRenderData", "<init>"));
        }
        super(icon, color, series.getLabel());
        this.myRange = range;
        this.mySeries = series;
        this.myFormatter = formatter;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String getFormattedData() {
        double time = this.myRange.getMax();
        ImmutableList data = this.mySeries.getDataSeries().getDataForXRange(new Range(time, time));
        if (data.isEmpty()) {
            return null;
        }
        SeriesData<Long> key = new SeriesData<Long>(TimeUnit.MICROSECONDS.toNanos((long)time), 0L);
        int index = Collections.binarySearch(data, key, (left, right) -> {
            long diff = left.x - right.x;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        index = index >= 0 ? index : -(index + 1);
        index = Math.max(0, Math.min(data.size() - 1, index));
        return this.myFormatter.getFormattedString(this.mySeries.getYRange().getLength(), ((Long)((SeriesData)data.get((int)index)).value).longValue(), true);
    }
}

