/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.LineChartLegendRenderData;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.datareducer.DataReducer;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.TDoubleArrayList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LineChart
extends AnimatedComponent {
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myLinesConfig;
    @NotNull
    private final ArrayList<Path2D> myLinePaths;
    @NotNull
    private final ArrayList<LineConfig> myLinePathConfigs;
    @NotNull
    private final List<LineChartCustomRenderer> myCustomRenderers;
    private int mNextLineColorIndex;
    @NotNull
    private DataReducer myReducer;
    private boolean myFirstUpdate;

    public LineChart() {
        this.myLinesConfig = new LinkedHashMap<RangedContinuousSeries, LineConfig>();
        this.myCustomRenderers = new ArrayList<LineChartCustomRenderer>();
        this.myFirstUpdate = true;
        this.myLinePaths = new ArrayList();
        this.myLinePathConfigs = new ArrayList();
        this.myReducer = (path, config) -> path;
    }

    public LineChart(@NotNull DataReducer reducer) {
        if (reducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reducer", "com/android/tools/adtui/chart/linechart/LineChart", "<init>"));
        }
        this();
        this.myReducer = reducer;
    }

    public LineChart(@NotNull List<RangedContinuousSeries> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/chart/linechart/LineChart", "<init>"));
        }
        this();
        this.addLines(data);
    }

    public void addLine(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/LineChart", "addLine"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/android/tools/adtui/chart/linechart/LineChart", "addLine"));
        }
        this.myLinesConfig.put(series, config);
    }

    public void addLine(@NotNull RangedContinuousSeries series) {
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/LineChart", "addLine"));
        }
        this.addLine(series, new LineConfig(LineConfig.getColor(this.mNextLineColorIndex++)));
    }

    public void addLines(@NotNull List<RangedContinuousSeries> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/chart/linechart/LineChart", "addLines"));
        }
        data.forEach(this::addLine);
    }

    public void addCustomRenderer(@NotNull LineChartCustomRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/adtui/chart/linechart/LineChart", "addCustomRenderer"));
        }
        this.myCustomRenderers.add(renderer);
    }

    @NotNull
    public LineConfig getLineConfig(RangedContinuousSeries rangedContinuousSeries) {
        LineConfig lineConfig = this.myLinesConfig.get(rangedContinuousSeries);
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineChart", "getLineConfig"));
        }
        return lineConfig;
    }

    public void clearConfigs() {
        this.myLinesConfig.clear();
        this.myCustomRenderers.clear();
    }

    @NotNull
    public List<RangedContinuousSeries> getRangedContinuousSeries() {
        ArrayList<RangedContinuousSeries> arrayList = new ArrayList<RangedContinuousSeries>(this.myLinesConfig.keySet());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineChart", "getRangedContinuousSeries"));
        }
        return arrayList;
    }

    @Override
    protected void updateData() {
        Range range;
        HashMap<Range, Double> max = new HashMap<Range, Double>();
        for (RangedContinuousSeries rangedContinuousSeries : this.myLinesConfig.keySet()) {
            range = rangedContinuousSeries.getYRange();
            double yMax = Double.MIN_VALUE;
            ImmutableList seriesList = rangedContinuousSeries.getSeries();
            for (int i = 0; i < seriesList.size(); ++i) {
                double value = ((Long)((SeriesData)seriesList.get((int)i)).value).longValue();
                if (!(yMax < value)) continue;
                yMax = value;
            }
            Double m = (Double)max.get(range);
            max.put(range, m == null ? yMax : Math.max(yMax, m));
        }
        for (Map.Entry entry : max.entrySet()) {
            range = (Range)entry.getKey();
            if (!(range.getMax() < (Double)entry.getValue())) continue;
            float fraction = this.myFirstUpdate ? 1.0f : 0.99f;
            range.setMax(Choreographer.lerp(range.getMax(), (Double)entry.getValue(), fraction, this.mFrameLength, (float)((Double)entry.getValue() * (double)0.001f)));
        }
        this.myFirstUpdate = false;
    }

    public LegendRenderData createLegendRenderData(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range) {
        LegendRenderData.IconType icon;
        Color color;
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/LineChart", "createLegendRenderData"));
        }
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/android/tools/adtui/chart/linechart/LineChart", "createLegendRenderData"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/adtui/chart/linechart/LineChart", "createLegendRenderData"));
        }
        LineConfig config = this.myLinesConfig.get(series);
        if (config != null) {
            color = config.getColor();
            icon = config.getLegendIconType();
            if (icon == null) {
                icon = config.isFilled() ? LegendRenderData.IconType.BOX : LegendRenderData.IconType.LINE;
            }
        } else {
            color = LineConfig.getColor(this.mNextLineColorIndex++);
            icon = LegendRenderData.IconType.BOX;
        }
        return new LineChartLegendRenderData(icon, color, range, series, formatter);
    }

    @Override
    public void postAnimate() {
        long duration = System.nanoTime();
        int p = 0;
        TDoubleArrayList lastStackedSeriesY = null;
        ArrayDeque<Path2D.Float> orderedPaths = new ArrayDeque<Path2D.Float>(this.myLinesConfig.size());
        ArrayDeque<LineConfig> orderedConfigs = new ArrayDeque<LineConfig>(this.myLinesConfig.size());
        for (Map.Entry<RangedContinuousSeries, LineConfig> lineConfig : this.myLinesConfig.entrySet()) {
            RangedContinuousSeries ranged = lineConfig.getKey();
            LineConfig config = lineConfig.getValue();
            TDoubleArrayList currentSeriesY = new TDoubleArrayList();
            Path2D.Float path = new Path2D.Float();
            double xMin = ranged.getXRange().getMin();
            double xMax = ranged.getXRange().getMax();
            double yMin = ranged.getYRange().getMin();
            double yMax = ranged.getYRange().getMax();
            double firstXd = 0.0;
            ImmutableList seriesList = ranged.getSeries();
            for (int i = 0; i < seriesList.size(); ++i) {
                SeriesData seriesData = (SeriesData)seriesList.get(i);
                long currX = seriesData.x;
                long currY = (Long)seriesData.value;
                double xd = ((double)currX - xMin) / (xMax - xMin);
                double yd = ((double)currY - yMin) / (yMax - yMin);
                if (config.isStacked() && lastStackedSeriesY != null && i < lastStackedSeriesY.size()) {
                    yd += lastStackedSeriesY.get(i);
                }
                currentSeriesY.add(yd);
                float adjustedYd = 1.0f - (float)yd;
                if (i == 0) {
                    ((Path2D)path).moveTo(xd, adjustedYd);
                    firstXd = xd;
                    continue;
                }
                if (config.isStepped()) {
                    float y = (float)path.getCurrentPoint().getY();
                    ((Path2D)path).lineTo(xd, y);
                }
                ((Path2D)path).lineTo(xd, adjustedYd);
            }
            if (config.isFilled() && path.getCurrentPoint() != null) {
                ((Path2D)path).lineTo(path.getCurrentPoint().getX(), 1.0);
                ((Path2D)path).lineTo(firstXd, 1.0);
            }
            if (config.isStacked()) {
                lastStackedSeriesY = currentSeriesY;
            }
            if (config.isFilled()) {
                orderedPaths.addFirst(path);
                orderedConfigs.addFirst(config);
            } else {
                orderedPaths.addLast(path);
                orderedConfigs.addLast(config);
            }
            this.addDebugInfo("Range[%d] Max: %.2f", p, xMax);
            ++p;
        }
        this.myLinePaths.clear();
        this.myLinePaths.addAll(orderedPaths);
        this.myLinePathConfigs.clear();
        this.myLinePathConfigs.addAll(orderedConfigs);
        this.addDebugInfo("postAnimate time: %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - duration));
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        if (this.myLinePaths.size() != this.myLinesConfig.size()) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform scale = AffineTransform.getScaleInstance(dim.getWidth(), dim.getHeight());
        ArrayList<Path2D> transformedPaths = new ArrayList<Path2D>(this.myLinePaths.size());
        for (int i = 0; i < this.myLinePaths.size(); ++i) {
            Path2D scaledPath = new Path2D.Float(this.myLinePaths.get(i), scale);
            scaledPath = this.myReducer.reduce(scaledPath, this.myLinePathConfigs.get(i));
            transformedPaths.add(scaledPath);
            if (!this.isDrawDebugInfo()) continue;
            int count = 0;
            PathIterator it = scaledPath.getPathIterator(null);
            while (!it.isDone()) {
                ++count;
                it.next();
            }
            this.addDebugInfo("# of points drawn: %d", count);
        }
        LineChart.drawLines(g2d, transformedPaths, this.myLinePathConfigs, false);
        this.myCustomRenderers.forEach(renderer -> renderer.renderLines(this, g2d, transformedPaths, this.myLinePathConfigs));
    }

    public static void drawLines(Graphics2D g2d, List<Path2D> transformedPaths, List<LineConfig> configs, boolean grayScale) {
        assert (transformedPaths.size() == configs.size());
        for (int i = 0; i < transformedPaths.size(); ++i) {
            Path2D path = transformedPaths.get(i);
            LineConfig config = configs.get(i);
            Color lineColor = config.getColor();
            if (grayScale) {
                int gray = (lineColor.getBlue() + lineColor.getRed() + lineColor.getGreen()) / 3;
                g2d.setColor(new Color(gray, gray, gray));
            } else {
                g2d.setColor(lineColor);
            }
            g2d.setStroke(config.getStroke());
            if (config.isFilled()) {
                g2d.fill(path);
                continue;
            }
            g2d.draw(path);
        }
    }
}

