/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FloatingToolWindow<T>
implements Disposable {
    private final ToolContent<T> myContent;
    private final ToolWindowEx myToolWindow;
    private AttachedToolWindow<T> myCorrespondingToolWindow;

    public FloatingToolWindow(@NotNull Project project, @NotNull ToolWindowDefinition<T> definition) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/adtui/workbench/FloatingToolWindow", "<init>"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/android/tools/adtui/workbench/FloatingToolWindow", "<init>"));
        }
        this(definition, ToolWindowManager.getInstance((Project)project));
    }

    public FloatingToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ToolWindowManager toolWindowManager) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/android/tools/adtui/workbench/FloatingToolWindow", "<init>"));
        }
        if (toolWindowManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/android/tools/adtui/workbench/FloatingToolWindow", "<init>"));
        }
        this.myContent = (ToolContent)definition.getFactory().create();
        this.myToolWindow = this.createToolWindow(toolWindowManager, definition);
        Disposer.register((Disposable)this, this.myContent);
    }

    public void show(@NotNull AttachedToolWindow<T> correspondingWindow) {
        if (correspondingWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correspondingWindow", "com/android/tools/adtui/workbench/FloatingToolWindow", "show"));
        }
        this.updateState(correspondingWindow);
        this.myContent.setToolContext(correspondingWindow.getContext());
        this.myToolWindow.setAvailable(true, null);
        this.myToolWindow.show(null);
    }

    public void hide() {
        this.myContent.setToolContext(null);
        this.myToolWindow.setAvailable(false, null);
    }

    private void updateState(@NotNull AttachedToolWindow<T> correspondingWindow) {
        if (correspondingWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correspondingWindow", "com/android/tools/adtui/workbench/FloatingToolWindow", "updateState"));
        }
        this.myCorrespondingToolWindow = correspondingWindow;
        ToolWindowAnchor anchor = correspondingWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        this.myToolWindow.setAnchor(anchor, null);
    }

    private ToolWindowEx createToolWindow(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindowDefinition<T> definition) {
        if (toolWindowManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/android/tools/adtui/workbench/FloatingToolWindow", "createToolWindow"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/android/tools/adtui/workbench/FloatingToolWindow", "createToolWindow"));
        }
        String id = definition.getTitle();
        ToolWindowEx window = (ToolWindowEx)toolWindowManager.getToolWindow(id);
        if (window == null) {
            ToolWindowAnchor anchor = definition.getSide().isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
            window = (ToolWindowEx)toolWindowManager.registerToolWindow(id, false, anchor, (Disposable)this, true);
            window.setIcon(definition.getIcon());
            window.setType(ToolWindowType.FLOATING, null);
            window.setAutoHide(false);
            this.setToolWindowContent(window);
            this.setAdditionalGearPopupActions(window);
            this.setAdditionalActions(window);
        }
        return window;
    }

    private void setToolWindowContent(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/adtui/workbench/FloatingToolWindow", "setToolWindowContent"));
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getSelectedContent();
        if (content == null) {
            content = contentManager.getFactory().createContent(this.myContent.getComponent(), null, false);
            content.setCloseable(false);
            content.setComponent(this.myContent.getComponent());
            content.setPreferredFocusableComponent(this.myContent.getFocusedComponent());
            content.setShouldDisposeContent(true);
            contentManager.addContent(content);
            contentManager.setSelectedContent(content, true);
        }
    }

    private void setAdditionalActions(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/adtui/workbench/FloatingToolWindow", "setAdditionalActions"));
        }
        List<AnAction> actionList = this.myContent.getAdditionalActions();
        if (!actionList.isEmpty()) {
            AnAction[] actions = new AnAction[actionList.size()];
            actionList.toArray(actions);
            toolWindow.setTitleActions(actions);
        }
    }

    private void setAdditionalGearPopupActions(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/adtui/workbench/FloatingToolWindow", "setAdditionalGearPopupActions"));
        }
        DefaultActionGroup attachedSide = new DefaultActionGroup("Attached Side", true);
        attachedSide.add((AnAction)new AttachToSideAction(Side.LEFT));
        attachedSide.add((AnAction)new AttachToSideAction(Side.RIGHT));
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{attachedSide}));
    }

    public void dispose() {
    }

    private class AttachToSideAction
    extends AnAction {
        private final Side mySide;

        public AttachToSideAction(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/FloatingToolWindow$AttachToSideAction", "<init>"));
            }
            super(side.isLeft() ? "Left" : "Right");
            this.mySide = side;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/FloatingToolWindow$AttachToSideAction", "update"));
            }
            event.getPresentation().setEnabledAndVisible(FloatingToolWindow.this.myCorrespondingToolWindow != null);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/FloatingToolWindow$AttachToSideAction", "actionPerformed"));
            }
            if (FloatingToolWindow.this.myCorrespondingToolWindow != null) {
                FloatingToolWindow.this.myToolWindow.setAvailable(false, null);
                FloatingToolWindow.this.myCorrespondingToolWindow.setLeft(this.mySide.isLeft());
                FloatingToolWindow.this.myCorrespondingToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.FLOATING, false);
            }
        }
    }
}

