/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.LocalFunctionCollector;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class FunctionBodyTranslator
extends AbstractTranslator {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final KtDeclarationWithBody declaration;

    @NotNull
    public static JsBlock translateFunctionBody(@NotNull FunctionDescriptor descriptor2, @NotNull KtDeclarationWithBody declarationWithBody, @NotNull TranslationContext functionBodyContext) {
        if (descriptor2 == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(0);
        }
        if (declarationWithBody == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(1);
        }
        if (functionBodyContext == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(2);
        }
        HashMap<DeclarationDescriptor, JsExpression> aliases = new HashMap<DeclarationDescriptor, JsExpression>();
        LocalFunctionCollector functionCollector = new LocalFunctionCollector(functionBodyContext.bindingContext());
        declarationWithBody.acceptChildren(functionCollector, null);
        for (FunctionDescriptor localFunction : functionCollector.getFunctions()) {
            String localIdent = localFunction.getName().isSpecial() ? "lambda" : localFunction.getName().asString();
            JsName localName = JsScope.declareTemporaryName(NameSuggestion.sanitizeName(localIdent));
            MetadataProperties.setDescriptor(localName, (DeclarationDescriptor)localFunction);
            JsNameRef alias = JsAstUtils.pureFqn(localName, null);
            aliases.put(localFunction, alias);
        }
        if (!aliases.isEmpty()) {
            functionBodyContext = functionBodyContext.innerContextWithDescriptorsAliased(aliases);
        }
        JsBlock jsBlock = new FunctionBodyTranslator(descriptor2, declarationWithBody, functionBodyContext).translate();
        if (jsBlock == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(3);
        }
        return jsBlock;
    }

    @NotNull
    public static List<JsStatement> setDefaultValueForArguments(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext functionBodyContext) {
        if (descriptor2 == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(4);
        }
        if (functionBodyContext == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(5);
        }
        List<ValueParameterDescriptor> valueParameters = descriptor2.getValueParameters();
        ArrayList<JsStatement> result2 = new ArrayList<JsStatement>(valueParameters.size());
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            if (!valueParameter.declaresDefaultValue()) continue;
            JsExpression jsNameRef = ReferenceTranslator.translateAsValueReference(valueParameter, functionBodyContext);
            KtExpression defaultArgument = BindingUtils.getDefaultArgument(valueParameter);
            JsBlock defaultArgBlock = new JsBlock();
            JsExpression defaultValue = Translation.translateAsExpression(defaultArgument, functionBodyContext, defaultArgBlock);
            PsiElement psi = KotlinSourceElementKt.getPsi(valueParameter.getSource());
            JsStatement assignStatement = JsAstUtils.assignment(jsNameRef, defaultValue).source(psi).makeStmt();
            JsStatement thenStatement = JsAstUtils.mergeStatementInBlockIfNeeded(assignStatement, defaultArgBlock);
            JsBinaryOperation checkArgIsUndefined = JsAstUtils.equality(jsNameRef, Namer.getUndefinedExpression());
            checkArgIsUndefined.source(KotlinSourceElementKt.getPsi(valueParameter.getSource()));
            JsIf jsIf = JsAstUtils.newJsIf(checkArgIsUndefined, thenStatement);
            jsIf.setSource(checkArgIsUndefined.getSource());
            result2.add(jsIf);
        }
        ArrayList<JsStatement> arrayList = result2;
        if (arrayList == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private FunctionBodyTranslator(@NotNull FunctionDescriptor descriptor2, @NotNull KtDeclarationWithBody declaration, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(7);
        }
        if (declaration == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(8);
        }
        if (context == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(9);
        }
        super(context);
        this.descriptor = descriptor2;
        this.declaration = declaration;
    }

    @NotNull
    private JsBlock translate() {
        KtExpression jetBodyExpression = this.declaration.getBodyExpression();
        assert (jetBodyExpression != null) : "Cannot translate a body of an abstract function.";
        JsBlock jsBlock = new JsBlock();
        JsNode jsBody = Translation.translateExpression(jetBodyExpression, this.context(), jsBlock);
        jsBlock.getStatements().addAll(this.mayBeWrapWithReturn(jsBody).getStatements());
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(10);
        }
        return jsBlock2;
    }

    @NotNull
    private JsBlock mayBeWrapWithReturn(@NotNull JsNode body) {
        if (body == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(11);
        }
        if (!this.mustAddReturnToGeneratedFunctionBody()) {
            JsBlock jsBlock = JsAstUtils.convertToBlock(body);
            if (jsBlock == null) {
                FunctionBodyTranslator.$$$reportNull$$$0(12);
            }
            return jsBlock;
        }
        JsBlock jsBlock = JsAstUtils.convertToBlock(this.lastExpressionReturned(body));
        if (jsBlock == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(13);
        }
        return jsBlock;
    }

    private boolean mustAddReturnToGeneratedFunctionBody() {
        KotlinType functionReturnType = this.descriptor.getReturnType();
        assert (functionReturnType != null) : "Function return typed type must be resolved.";
        return !this.declaration.hasBlockBody() && (!KotlinBuiltIns.isUnit(functionReturnType) || this.descriptor.isSuspend());
    }

    @NotNull
    private JsNode lastExpressionReturned(@NotNull JsNode body) {
        if (body == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(14);
        }
        JsStatement jsStatement = LastExpressionMutator.mutateLastExpression(body, node -> {
            if (!(node instanceof JsExpression)) {
                return node;
            }
            assert (this.declaration.getBodyExpression() != null);
            assert (this.descriptor.getReturnType() != null);
            KotlinType bodyType = this.context().bindingContext().getType(this.declaration.getBodyExpression());
            if (bodyType == null && KotlinBuiltIns.isCharOrNullableChar(this.descriptor.getReturnType()) || bodyType != null && KotlinBuiltIns.isCharOrNullableChar(bodyType) && TranslationUtils.shouldBoxReturnValue(this.descriptor)) {
                node = JsAstUtils.charToBoxedChar((JsExpression)node);
            }
            JsReturn jsReturn = new JsReturn((JsExpression)node);
            jsReturn.setSource(this.declaration.getBodyExpression());
            MetadataProperties.setReturnTarget(jsReturn, this.descriptor);
            return jsReturn;
        });
        if (jsStatement == null) {
            FunctionBodyTranslator.$$$reportNull$$$0(15);
        }
        return jsStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationWithBody";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionBodyContext";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "translateFunctionBody";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setDefaultValueForArguments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mayBeWrapWithReturn";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "lastExpressionReturned";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateFunctionBody";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValueForArguments";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mayBeWrapWithReturn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lastExpressionReturned";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

