/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupport;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupportKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinEnum;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Function1<KotlinType, Boolean> VALID_SUPERTYPE = type2 -> {
        assert (!KotlinTypeKt.isError(type2)) : "Error types must be filtered out in DescriptorResolver";
        return TypeUtils.getClassDescriptor(type2) != null;
    };
    private final LazyClassContext c;
    @Nullable
    private final KtClassOrObject classOrObject;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final NotNullLazyValue<Modality> modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final boolean isData;
    private final boolean isHeader;
    private final boolean isImpl;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<ClassDescriptorWithResolutionScopes> companionObjectDescriptor;
    private final MemoizedFunctionToNotNull<KtObjectDeclaration, ClassDescriptor> extraCompanionObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final MemberScope staticScope;
    private final NullableLazyValue<Void> forceResolveAllContents;
    private final boolean isCompanionObject;
    private final ClassResolutionScopesSupport resolutionScopesSupport;
    private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
    private final NotNullLazyValue<LexicalScope> scopeForInitializerResolution;
    private final NotNullLazyValue<Collection<ClassDescriptor>> sealedSubclasses;

    public LazyClassDescriptor(@NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull KtClassLikeInfo classLikeInfo, boolean isExternal) {
        if (c == null) {
            LazyClassDescriptor.$$$reportNull$$$0(0);
        }
        if (containingDeclaration == null) {
            LazyClassDescriptor.$$$reportNull$$$0(1);
        }
        if (name == null) {
            LazyClassDescriptor.$$$reportNull$$$0(2);
        }
        if (classLikeInfo == null) {
            LazyClassDescriptor.$$$reportNull$$$0(3);
        }
        super(c.getStorageManager(), containingDeclaration, name, KotlinSourceElementKt.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()), isExternal);
        this.c = c;
        this.classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        if (this.classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, this.classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        StorageManager storageManager = c.getStorageManager();
        this.unsubstitutedMemberScope = this.createMemberScope(c, this.declarationProvider);
        this.kind = classLikeInfo.getClassKind();
        this.staticScope = this.kind == ClassKind.ENUM_CLASS ? new StaticScopeForKotlinEnum(storageManager, this) : MemberScope.Empty.INSTANCE;
        this.typeConstructor = new LazyClassTypeConstructor();
        this.isCompanionObject = classLikeInfo instanceof KtObjectInfo && ((KtObjectInfo)classLikeInfo).isCompanionObject();
        KtModifierList modifierList = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = storageManager.createLazyValue(() -> Modality.FINAL);
        } else {
            Modality defaultModality = this.kind == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = storageManager.createLazyValue(() -> {
                if (c == null) {
                    LazyClassDescriptor.$$$reportNull$$$0(34);
                }
                return ModifiersChecker.resolveModalityFromModifiers(this.classOrObject, defaultModality, c.getTrace().getBindingContext(), null, true);
            });
        }
        boolean isLocal = this.classOrObject != null && KtPsiUtil.isLocal(this.classOrObject);
        Visibility defaultVisibility = this.kind == ClassKind.ENUM_ENTRY || this.kind == ClassKind.OBJECT && this.isCompanionObject ? Visibilities.PUBLIC : Visibilities.DEFAULT_VISIBILITY;
        this.visibility = isLocal ? Visibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, defaultVisibility);
        this.isInner = ModifiersChecker.isInnerClass(modifierList) && !ModifiersChecker.isIllegalInner(this);
        this.isData = modifierList != null && modifierList.hasModifier(KtTokens.DATA_KEYWORD);
        this.isHeader = modifierList != null && modifierList.hasModifier(KtTokens.HEADER_KEYWORD);
        this.isImpl = modifierList != null && modifierList.hasModifier(KtTokens.IMPL_KEYWORD);
        ArrayList<KtAnnotationEntry> annotationEntries = new ArrayList<KtAnnotationEntry>();
        if (this.classOrObject != null && this.classOrObject.getParent() instanceof KtObjectLiteralExpression) {
            annotationEntries.addAll(KtPsiUtilKt.getAnnotationEntries((KtObjectLiteralExpression)this.classOrObject.getParent()));
        }
        if (modifierList != null) {
            annotationEntries.addAll(modifierList.getAnnotationEntries());
        }
        this.annotations = !annotationEntries.isEmpty() ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getOuterScope();
                if (lexicalScope == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lexicalScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$1", "getScope"));
            }
        }, annotationEntries) : Annotations.Companion.getEMPTY();
        List<KtAnnotationEntry> jetDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = jetDanglingAnnotations.isEmpty() ? Annotations.Companion.getEMPTY() : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
                if (lexicalScope == null) {
                    2.$$$reportNull$$$0(0);
                }
                return lexicalScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$2", "getScope"));
            }
        }, jetDanglingAnnotations);
        this.companionObjectDescriptor = storageManager.createNullableLazyValue(() -> this.computeCompanionObjectDescriptor(this.getCompanionObjectIfAllowed()));
        this.extraCompanionObjectDescriptors = storageManager.createMemoizedFunction(this::computeCompanionObjectDescriptor);
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(() -> {
            this.doForceResolveAllContents();
            return null;
        }, null);
        this.resolutionScopesSupport = new ClassResolutionScopesSupport(this, storageManager, this::getOuterScope);
        this.parameters = c.getStorageManager().createLazyValue(() -> {
            List<KtTypeParameter> typeParameters;
            KtClassLikeInfo classInfo;
            KtTypeParameterList typeParameterList;
            if (c == null) {
                LazyClassDescriptor.$$$reportNull$$$0(33);
            }
            if ((typeParameterList = (classInfo = this.declarationProvider.getOwnerInfo()).getTypeParameterList()) == null) {
                return Collections.emptyList();
            }
            if (classInfo.getClassKind() == ClassKind.ENUM_CLASS) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
            }
            if (classInfo.getClassKind() == ClassKind.OBJECT) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_OBJECT.on(typeParameterList));
            }
            if ((typeParameters = typeParameterList.getParameters()).isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<LazyTypeParameterDescriptor> parameters2 = new ArrayList<LazyTypeParameterDescriptor>(typeParameters.size());
            for (int i = 0; i < typeParameters.size(); ++i) {
                parameters2.add(new LazyTypeParameterDescriptor(c, this, typeParameters.get(i), i));
            }
            return parameters2;
        });
        this.scopeForInitializerResolution = storageManager.createLazyValue(() -> {
            if (classLikeInfo == null) {
                LazyClassDescriptor.$$$reportNull$$$0(32);
            }
            return ClassResolutionScopesSupportKt.scopeForInitializerResolution(this, this.createInitializerScopeParent(), classLikeInfo.getPrimaryConstructorParameters());
        });
        this.sealedSubclasses = storageManager.createLazyValue(() -> DescriptorUtilsKt.computeSealedSubclasses(this));
    }

    @NotNull
    private DeclarationDescriptor createInitializerScopeParent() {
        ClassConstructorDescriptor primaryConstructor2 = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            ClassConstructorDescriptor classConstructorDescriptor = primaryConstructor2;
            if (classConstructorDescriptor == null) {
                LazyClassDescriptor.$$$reportNull$$$0(4);
            }
            return classConstructorDescriptor;
        }
        FunctionDescriptorImpl functionDescriptorImpl = new FunctionDescriptorImpl(this, null, Annotations.Companion.getEMPTY(), Name.special("<init-blocks>"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE){
            {
                this.initialize(null, null, Collections.emptyList(), Collections.emptyList(), null, Modality.FINAL, Visibilities.PRIVATE);
            }

            @Override
            @NotNull
            protected FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
                if (newOwner == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (kind == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (annotations2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (source == null) {
                    3.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newOwner";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "annotations";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3";
                objectArray[2] = "createSubstitutedCopy";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (functionDescriptorImpl == null) {
            LazyClassDescriptor.$$$reportNull$$$0(5);
        }
        return functionDescriptorImpl;
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (c == null) {
            LazyClassDescriptor.$$$reportNull$$$0(6);
        }
        if (declarationProvider == null) {
            LazyClassDescriptor.$$$reportNull$$$0(7);
        }
        LazyClassMemberScope lazyClassMemberScope = new LazyClassMemberScope(c, declarationProvider, this, c.getTrace());
        if (lazyClassMemberScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(8);
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        LazyClassMemberScope lazyClassMemberScope = this.unsubstitutedMemberScope;
        if (lazyClassMemberScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(9);
        }
        return lazyClassMemberScope;
    }

    @NotNull
    protected LexicalScope getOuterScope() {
        LexicalScope lexicalScope = this.c.getDeclarationScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(10);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForClassHeaderResolution() {
        LexicalScope lexicalScope = this.resolutionScopesSupport.getScopeForClassHeaderResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(11);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForConstructorHeaderResolution() {
        LexicalScope lexicalScope = this.resolutionScopesSupport.getScopeForConstructorHeaderResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(12);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForCompanionObjectHeaderResolution() {
        LexicalScope lexicalScope = this.resolutionScopesSupport.getScopeForCompanionObjectHeaderResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(13);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForMemberDeclarationResolution() {
        LexicalScope lexicalScope = this.resolutionScopesSupport.getScopeForMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(14);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForStaticMemberDeclarationResolution() {
        LexicalScope lexicalScope = this.resolutionScopesSupport.getScopeForStaticMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(15);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForInitializerResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.scopeForInitializerResolution.invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(16);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List<DeclarationDescriptor> list2 = CollectionsKt.filter(DescriptorUtils.getAllDescriptors(this.unsubstitutedMemberScope), descriptor2 -> descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE);
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2 = this.staticScope;
        if (memberScope2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(18);
        }
        return memberScope2;
    }

    @Override
    @NotNull
    public Collection<ClassConstructorDescriptor> getConstructors() {
        Collection<ClassConstructorDescriptor> collection = this.unsubstitutedMemberScope.getConstructors();
        if (collection == null) {
            LazyClassDescriptor.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @Override
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            LazyClassDescriptor.$$$reportNull$$$0(20);
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public ClassDescriptorWithResolutionScopes getCompanionObjectDescriptor() {
        return (ClassDescriptorWithResolutionScopes)this.companionObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraCompanionObjects() {
        KtObjectDeclaration allowedCompanionObject = this.getCompanionObjectIfAllowed();
        List<ClassDescriptor> list2 = CollectionsKt.map(CollectionsKt.filter(this.declarationProvider.getOwnerInfo().getCompanionObjects(), companionObject -> companionObject != allowedCompanionObject), this.extraCompanionObjectDescriptors);
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Nullable
    private ClassDescriptorWithResolutionScopes computeCompanionObjectDescriptor(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject == null) {
            return this.createSyntheticCompanionObjectDescriptor();
        }
        KtClassLikeInfo companionObjectInfo = LazyClassDescriptor.getCompanionObjectInfo(companionObject);
        if (!(companionObjectInfo instanceof KtClassOrObjectInfo)) {
            return null;
        }
        Name name = ((KtClassOrObjectInfo)companionObjectInfo).getName();
        assert (name != null);
        this.getUnsubstitutedMemberScope().getContributedClassifier(name, NoLookupLocation.WHEN_GET_COMPANION_OBJECT);
        ClassDescriptor companionObjectDescriptor2 = this.c.getTrace().get(BindingContext.CLASS, companionObject);
        if (companionObjectDescriptor2 instanceof ClassDescriptorWithResolutionScopes) {
            assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Not a companion object: " + companionObjectDescriptor2;
            return (ClassDescriptorWithResolutionScopes)companionObjectDescriptor2;
        }
        return null;
    }

    private ClassDescriptorWithResolutionScopes createSyntheticCompanionObjectDescriptor() {
        Name syntheticCompanionName = this.c.getSyntheticResolveExtension().getSyntheticCompanionObjectNameIfNeeded(this);
        if (syntheticCompanionName == null) {
            return null;
        }
        return new SyntheticClassOrObjectDescriptor(this.c, this.classOrObject, this, syntheticCompanionName, this.getSource(), this.getOuterScope(), Modality.FINAL, Visibilities.PUBLIC, ClassKind.OBJECT, true);
    }

    @Nullable
    private static KtClassLikeInfo getCompanionObjectInfo(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject != null) {
            return KtClassInfoUtil.createClassLikeInfo(companionObject);
        }
        return null;
    }

    @Nullable
    private KtObjectDeclaration getCompanionObjectIfAllowed() {
        KtObjectDeclaration companionObject = CollectionsKt.firstOrNull(this.declarationProvider.getOwnerInfo().getCompanionObjects());
        return companionObject != null && this.isCompanionObjectAllowed() ? companionObject : null;
    }

    private boolean isCompanionObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            LazyClassDescriptor.$$$reportNull$$$0(22);
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = (Modality)((Object)this.modality.invoke());
        if (modality == null) {
            LazyClassDescriptor.$$$reportNull$$$0(23);
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            LazyClassDescriptor.$$$reportNull$$$0(24);
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isData() {
        return this.isData;
    }

    @Override
    public boolean isCompanionObject() {
        return this.isCompanionObject;
    }

    @Override
    public boolean isHeader() {
        return this.isHeader;
    }

    @Override
    public boolean isImpl() {
        return this.isImpl;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(25);
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        Annotations annotations2 = this.danglingAnnotations;
        if (annotations2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(26);
        }
        return annotations2;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        Collection collection = (Collection)this.sealedSubclasses.invoke();
        if (collection == null) {
            LazyClassDescriptor.$$$reportNull$$$0(27);
        }
        return collection;
    }

    public String toString() {
        return (this.isHeader ? "header " : (this.isImpl ? "impl " : "")) + "class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        ClassDescriptorWithResolutionScopes companionObjectDescriptor2 = this.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(companionObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraCompanionObjects());
        ForceResolveUtil.forceResolveAllContents(this.getUnsubstitutedMemberScope());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getCompanionObjectDescriptor();
        this.getDescriptorsForExtraCompanionObjects();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        DescriptorUtils.getAllDescriptors(this.getUnsubstitutedMemberScope());
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        List list2 = (List)this.parameters.invoke();
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    protected Collection<KotlinType> computeSupertypes() {
        if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(this)) {
            List<KotlinType> list2 = Collections.emptyList();
            if (list2 == null) {
                LazyClassDescriptor.$$$reportNull$$$0(29);
            }
            return list2;
        }
        KtClassOrObject classOrObject = this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
        if (classOrObject == null) {
            Set<KotlinType> set = Collections.singleton(this.c.getModuleDescriptor().getBuiltIns().getAnyType());
            if (set == null) {
                LazyClassDescriptor.$$$reportNull$$$0(30);
            }
            return set;
        }
        List<KotlinType> allSupertypes2 = this.c.getDescriptorResolver().resolveSupertypes(this.getScopeForClassHeaderResolution(), this, classOrObject, this.c.getTrace());
        ArrayList<KotlinType> arrayList = new ArrayList<KotlinType>(CollectionsKt.filter(allSupertypes2, VALID_SUPERTYPE));
        if (arrayList == null) {
            LazyClassDescriptor.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLikeInfo";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializerScopeParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsubstitutedMemberScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForClassHeaderResolution";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForConstructorHeaderResolution";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForCompanionObjectHeaderResolution";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForMemberDeclarationResolution";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForStaticMemberDeclarationResolution";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForInitializerResolution";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredCallableMembers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeConstructor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorsForExtraCompanionObjects";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModality";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDanglingAnnotations";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSealedSubclasses";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredTypeParameters";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSupertypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMemberScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$6";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$5";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor {
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;

        public LazyClassTypeConstructor() {
            super(LazyClassDescriptor.this.c.getStorageManager());
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(() -> TypeParameterUtilsKt.computeConstructorTypeParameters(LazyClassDescriptor.this));
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            Collection<KotlinType> collection = LazyClassDescriptor.this.computeSupertypes();
            if (collection == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            ClassifierDescriptor supertypeDescriptor;
            if (type2 == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(1);
            }
            if ((supertypeDescriptor = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            if (trace == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(2);
            }
            if (classDescriptor == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(3);
            }
            if (superclass == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(4);
            }
            PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)psiElement;
                for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
                    KotlinType supertype;
                    KtTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            SupertypeLoopChecker supertypeLoopChecker = LazyClassDescriptor.this.c.getSupertypeLoopChecker();
            if (supertypeLoopChecker == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(5);
            }
            return supertypeLoopChecker;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list2 = (List)this.parameters.invoke();
            if (list2 == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @Override
        public boolean isFinal() {
            return LazyClassDescriptor.this.getModality() == Modality.FINAL;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassifierDescriptor getDeclarationDescriptor() {
            LazyClassDescriptor lazyClassDescriptor = LazyClassDescriptor.this;
            if (lazyClassDescriptor == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(7);
            }
            return lazyClassDescriptor;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superclass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeSupertypes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupertypeLoopChecker";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reportSupertypeLoopError";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "reportCyclicInheritanceHierarchyError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

