/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonParamValue;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.StrutsModelImpl;
import com.intellij.struts.WebDomFactory;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsDomFactory
extends WebDomFactory<StrutsConfig, StrutsModel> {
    @NonNls
    private static final String CONFIG = "config";
    @NonNls
    private static final String CONFIG_PREFIX = "config/";

    public StrutsDomFactory(Project project) {
        super(StrutsConfig.class, project, "Struts");
    }

    @Nullable
    protected List<StrutsModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/StrutsDomFactory", "computeAllModels"));
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        ArrayList<StrutsModel> models = new ArrayList<StrutsModel>();
        for (WebFacet webFacet : webFacets) {
            List<StrutsModel> strutsModels = this.computeAllModels(webFacet);
            if (strutsModels == null) continue;
            models.addAll(strutsModels);
        }
        return models;
    }

    protected StrutsModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        DomFileElement dom;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/struts/StrutsDomFactory", "computeModel"));
        }
        StrutsModel model = (StrutsModel)super.computeModel(psiFile, (UserDataHolder)module);
        if (model != null) {
            return model;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiFile);
        if (webFacet == null) {
            return null;
        }
        ServletMappingInfo info = StrutsDomFactory.findStrutsMapping(webFacet);
        if (info != null && (dom = this.getDomRoot(psiFile)) != null) {
            return new StrutsModelImpl(Collections.singleton(psiFile), (DomFileElement<StrutsConfig>)dom, info, "/", null);
        }
        return null;
    }

    @Nullable
    private List<StrutsModel> computeAllModels(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/struts/StrutsDomFactory", "computeAllModels"));
        }
        ServletMappingInfo mappingInfo = StrutsDomFactory.findStrutsMapping(webFacet);
        if (mappingInfo == null) {
            return null;
        }
        List parameters = mappingInfo.getServlet().getInitParams();
        ArrayList<StrutsModel> strutsModels = new ArrayList<StrutsModel>();
        block0: for (CommonParamValue parameter : parameters) {
            DomFileElement mergedModel;
            String[] paths;
            String parameterName = (String)parameter.getParamName().getValue();
            if (parameterName == null) continue;
            String modulePath = null;
            if (parameterName.startsWith(CONFIG_PREFIX)) {
                modulePath = parameterName.substring(CONFIG_PREFIX.length() - 1);
            } else if (CONFIG.equals(parameterName)) {
                modulePath = "/";
            }
            if (modulePath == null) continue;
            for (StrutsModel model : strutsModels) {
                if (!model.getModulePrefix().equals(modulePath)) continue;
                continue block0;
            }
            String configList = (String)parameter.getParamValue().getValue();
            if (configList == null) continue;
            LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
            for (String path : paths = configList.split(",")) {
                PsiFileSystemItem file = WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findFileByPath(path.trim(), webFacet);
                if (!(file instanceof XmlFile)) continue;
                configFiles.add((XmlFile)file);
            }
            if (configFiles.size() <= 0 || (mergedModel = this.createMergedModelRoot(configFiles)) == null) continue;
            PsiElement tag = parameter.getIdentifyingPsiElement();
            assert (tag != null);
            StrutsModelImpl model = new StrutsModelImpl(configFiles, (DomFileElement<StrutsConfig>)mergedModel, mappingInfo, modulePath, tag);
            strutsModels.add(model);
        }
        return strutsModels;
    }

    @Nullable
    private static ServletMappingInfo findStrutsMapping(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/struts/StrutsDomFactory", "findStrutsMapping"));
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null) {
            return null;
        }
        Servlet actionServlet = StrutsDomFactory.findActionServlet(webApp);
        if (actionServlet == null) {
            return null;
        }
        ServletMapping strutsMapping = null;
        for (ServletMapping mapping : webApp.getServletMappings()) {
            if (!actionServlet.equals(mapping.getServletName().getValue())) continue;
            strutsMapping = mapping;
            break;
        }
        if (strutsMapping == null) {
            return null;
        }
        List list = strutsMapping.getUrlPatterns();
        if (list.size() == 0) {
            return null;
        }
        String urlPattern = ((GenericDomValue)list.get(0)).getStringValue();
        if (urlPattern == null) {
            return null;
        }
        ServletMappingInfo mappingInfo = ServletMappingType.getPatternType((String)urlPattern).createMappingInfo(urlPattern, (CommonServletMapping)strutsMapping);
        if (mappingInfo.getType() == ServletMappingType.EXACT) {
            return null;
        }
        return mappingInfo;
    }

    protected StrutsModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<StrutsConfig> mergedModel, StrutsModel firstModel, Module module) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/struts/StrutsDomFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/struts/StrutsDomFactory", "createCombinedModel"));
        }
        return new StrutsModelImpl(configFiles, mergedModel, firstModel.getServletMappingInfo(), "/", firstModel.getConfigurationTag());
    }

    @Nullable
    private static Servlet findActionServlet(@NotNull WebApp webApp) {
        if (webApp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webApp", "com/intellij/struts/StrutsDomFactory", "findActionServlet"));
        }
        PsiClass actionServletClass = null;
        List servlets = webApp.getServlets();
        for (Servlet servlet : servlets) {
            String stringValue;
            PsiClass servletPsiClass = (PsiClass)servlet.getServletClass().getValue();
            if (servletPsiClass != null) {
                if (actionServletClass == null) {
                    GlobalSearchScope scope = servlet.getResolveScope();
                    actionServletClass = JavaPsiFacade.getInstance((Project)servletPsiClass.getProject()).findClass("org.apache.struts.action.ActionServlet", scope);
                    if (actionServletClass == null) {
                        return null;
                    }
                }
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)servletPsiClass, actionServletClass, (boolean)true)) {
                    return servlet;
                }
            }
            if ((stringValue = servlet.getServletClass().getStringValue()) == null || !stringValue.equals("org.apache.struts.action.ActionServlet")) continue;
            return servlet;
        }
        return null;
    }
}

