/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.emmet.nodes.CssEmmetNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyEmmetNode
extends CssEmmetNode {
    private final String myName;

    public CssPropertyEmmetNode(String propertyName, List<String> values, Collection<CssPrefix> prefixes, boolean isImportant) {
        super(values, prefixes, isImportant);
        this.myName = propertyName;
    }

    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        TemplateToken templateToken = new TemplateToken("");
        String declarationsTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)callback.getContext());
        boolean caretAtTerminator = this.isCaretAtDeclarationsTerminator(callback.getEditor(), declarationsTerminator);
        templateToken.setTemplate(this.createDeclarationsTemplate(declarationsTerminator, caretAtTerminator), callback);
        GenerationNode node = new GenerationNode(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, declarationsTerminator.isEmpty());
        List<GenerationNode> list = Collections.singletonList(node);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/CssPropertyEmmetNode", "expand"));
        }
        return list;
    }

    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback) {
        int result = this.myName.length() + 1;
        if (!this.myValues.isEmpty()) {
            result += this.createValue(this.myName).length();
        }
        if (this.myImportant) {
            result += 12;
        }
        if (callback != null) {
            result += CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)callback.getContext()).length();
        }
        return result;
    }

    private TemplateImpl createDeclarationsTemplate(String declarationsTerminator, boolean caretAtTerminator) {
        String value;
        String string = value = this.myValues.isEmpty() ? "$VAR_EMMET_VALUE$" : this.createValue(this.myName);
        if (this.myImportant) {
            value = value + " !important";
        }
        TemplateImpl template = new TemplateImpl("", this.createDeclarationsString(this.myName, value, declarationsTerminator, !caretAtTerminator), "");
        template.setToReformat(true);
        template.setToIndent(true);
        if (this.myValues.isEmpty()) {
            template.addVariable("VAR_EMMET_VALUE", "VAR_EMMET_VALUE", "", true);
        }
        return template;
    }
}

