/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFunctionImpl
extends CssElementImpl
implements CssFunction {
    private static final Map<String, CssTermType> typeOfStringMap = ContainerUtil.newHashMap((Pair)Pair.create((Object)"%", (Object)CssTermTypes.PERCENTAGE), (Pair[])new Pair[]{Pair.create((Object)"string", (Object)CssTermTypes.STRING), Pair.create((Object)"number", (Object)CssTermTypes.NUMBER), Pair.create((Object)"integer", (Object)CssTermTypes.INTEGER), Pair.create((Object)"length", (Object)CssTermTypes.LENGTH), Pair.create((Object)"angle", (Object)CssTermTypes.ANGLE), Pair.create((Object)"time", (Object)CssTermTypes.TIME), Pair.create((Object)"frequency", (Object)CssTermTypes.FREQUENCY), Pair.create((Object)"color", (Object)CssTermTypes.COLOR), Pair.create((Object)"url", (Object)CssTermTypes.URI)});

    CssFunctionImpl() {
        super(CssElementTypes.CSS_FUNCTION);
    }

    @NotNull
    public String getName() {
        PsiElement namedElement = this.getNameIdentifier();
        String string = namedElement != null ? namedElement.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssFunctionImpl", "setName"));
        }
        PsiElement token = this.getNameIdentifier();
        if (token != null) {
            CssPsiUtil.replaceToken((PsiElement)token, (String)name);
        }
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getToken(CssElementTypes.CSS_FUNCTION_TOKEN);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssFunctionImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssFunction((CssFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> getDescriptors() {
        Collection<? extends CssFunctionDescriptor> collection = this.getDescriptors((PsiElement)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> getDescriptors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/CssFunctionImpl", "getDescriptors"));
        }
        Collection collection = CssDescriptorsUtil.getFunctionDescriptors((String)this.getName(), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getDescriptors"));
        }
        return collection;
    }

    @Nullable
    public CssTermList getValue() {
        return this.getChildOfType(CssTermList.class);
    }

    @NotNull
    public TextRange getTrimmedValueTextRange() {
        PsiElement lParenthesis = this.getLParenthesis();
        CssTermList termList = this.getValue();
        if (termList != null) {
            TextRange textRange = termList.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getTrimmedValueTextRange"));
            }
            return textRange;
        }
        int startOffset = lParenthesis != null ? lParenthesis.getTextRange().getStartOffset() : 0;
        PsiElement rParenthesis = this.getRParenthesis();
        int endOffset = rParenthesis != null ? rParenthesis.getTextRange().getEndOffset() : startOffset;
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getTrimmedValueTextRange"));
        }
        return textRange;
    }

    @NotNull
    public TextRange getValueTextRange() {
        PsiElement lParenthesis = this.getLParenthesis();
        int startOffset = lParenthesis != null ? lParenthesis.getTextRange().getEndOffset() : 0;
        CssTermList termList = this.getValue();
        PsiElement rParenthesis = this.getRParenthesis();
        int endOffset = rParenthesis != null ? rParenthesis.getTextRange().getEndOffset() : (termList != null ? termList.getTextRange().getEndOffset() : startOffset);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getValueTextRange"));
        }
        return textRange;
    }

    @Nullable
    public PsiElement getLParenthesis() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)nameIdentifier);
        return nextVisibleLeaf != null && nextVisibleLeaf.getNode().getElementType() == CssElementTypes.CSS_LPAREN ? nextVisibleLeaf : null;
    }

    @Nullable
    public PsiElement getRParenthesis() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RPAREN) {
            return lastChild;
        }
        return null;
    }

    @NotNull
    public CssTermType getType() {
        CssFunctionDescriptor descriptor;
        CssTermList termList;
        String name = CssPropertyUtil.getElementNameWithoutVendorPrefix(this.getName());
        if ("calc".equalsIgnoreCase(name)) {
            CssTerm firstTerm;
            termList = this.getValue();
            if (termList != null && (firstTerm = (CssTerm)ArrayUtil.getFirstElement((Object[])termList.getTerms())) != null) {
                CssTermType cssTermType = firstTerm.getTermType();
                if (cssTermType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getType"));
                }
                return cssTermType;
            }
        } else if ("attr".equalsIgnoreCase(name) && (termList = this.getValue()) != null) {
            CssTerm[] terms = termList.getTerms();
            if (terms.length > 1) {
                CssTerm firstTerm = terms[0];
                PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstTerm);
                CssTerm secondTerm = terms[1];
                if (nextVisibleLeaf != null) {
                    if (nextVisibleLeaf.getNode().getElementType() == CssElementTypes.CSS_COMMA) {
                        CssTermType cssTermType = secondTerm.getTermType();
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getType"));
                        }
                        return cssTermType;
                    }
                    String typeOfUnit = secondTerm.getText().trim().toLowerCase(Locale.US);
                    CssTermType cssTermType = typeOfStringMap.containsKey(typeOfUnit) ? typeOfStringMap.get(typeOfUnit) : CssTermImpl.getTypeBySuffix(typeOfUnit);
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getType"));
                    }
                    return cssTermType;
                }
            }
            CssTermType cssTermType = CssTermTypes.STRING;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getType"));
            }
            return cssTermType;
        }
        if ((descriptor = (CssFunctionDescriptor)ContainerUtil.getFirstItem((Collection)CssDescriptorsUtil.getFunctionDescriptors((String)name, (PsiElement)this))) != null) {
            CssTermType cssTermType = descriptor.getType();
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getType"));
            }
            return cssTermType;
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssFunctionImpl", "getType"));
        }
        return cssTermType;
    }
}

