/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssNamedItemPresentation
implements ItemPresentation {
    @NotNull
    private final PsiNamedElement myElement;
    @Nullable
    private final String myCustomText;

    public CssNamedItemPresentation(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/CssNamedItemPresentation", "<init>"));
        }
        this(element, null);
    }

    public CssNamedItemPresentation(@NotNull PsiNamedElement element, @Nullable String customText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/CssNamedItemPresentation", "<init>"));
        }
        this.myElement = element;
        this.myCustomText = customText;
    }

    @Nullable
    public String getPresentableText() {
        return this.myCustomText != null ? this.myCustomText : this.myElement.getName();
    }

    @Nullable
    public String getLocationString() {
        return this.getLocationString((PsiElement)this.myElement);
    }

    @Nullable
    protected String getLocationString(@NotNull PsiElement context) {
        int lineNumber;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/CssNamedItemPresentation", "getLocationString"));
        }
        String filePathPresentation = SymbolPresentationUtil.getFilePathPresentation((PsiFile)context.getContainingFile());
        if (this.myElement instanceof CssNamedElement && (lineNumber = ((CssNamedElement)this.myElement).getLineNumber()) > 0) {
            filePathPresentation = filePathPresentation + ":" + lineNumber;
        }
        return filePathPresentation;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myElement.getIcon(0);
    }

    public static class WithCustomContext
    implements ItemPresentation {
        private final CssNamedItemPresentation myOriginalPresentation;
        private final PsiElement myCustomContext;

        public WithCustomContext(@NotNull CssNamedItemPresentation originalPresentation, @NotNull PsiElement customContext) {
            if (originalPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPresentation", "com/intellij/psi/css/impl/CssNamedItemPresentation$WithCustomContext", "<init>"));
            }
            if (customContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customContext", "com/intellij/psi/css/impl/CssNamedItemPresentation$WithCustomContext", "<init>"));
            }
            this.myOriginalPresentation = originalPresentation;
            this.myCustomContext = customContext;
        }

        @Nullable
        public String getPresentableText() {
            return this.myOriginalPresentation.getPresentableText();
        }

        @Nullable
        public String getLocationString() {
            return this.myOriginalPresentation.getLocationString(this.myCustomContext);
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return this.myOriginalPresentation.getIcon(unused);
        }
    }
}

