/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "annotate"));
        }
        if (holder.isBatchMode()) {
            return;
        }
        if (element instanceof CssSimpleSelector) {
            PsiElement identifier = ((CssSimpleSelector)element).getNameIdentifier();
            String elementName = ((CssSimpleSelector)element).getElementName();
            if (identifier != null && CssDescriptorsUtil.isPossibleSelector((String)elementName, (PsiElement)element)) {
                CssHighlightingAnnotator.highlight(holder, identifier, CssElementTypes.CSS_TAG_NAME, CssHighlighter.CSS_TAG_NAME);
            }
        } else if (element instanceof CssAttribute) {
            PsiElement identifier = ((CssAttribute)element).getAttributeNameIdentifier();
            if (identifier != null) {
                CssHighlightingAnnotator.highlight(holder, identifier, CssElementTypes.CSS_ATTRIBUTE_NAME, CssHighlighter.CSS_ATTRIBUTE_NAME);
            }
        } else if (element.getNode().getElementType() == CssElementTypes.CSS_IDENT && element.getParent() instanceof CssClass) {
            CssHighlightingAnnotator.highlight(holder, element, CssElementTypes.CSS_CLASS_NAME, CssHighlighter.CSS_CLASS_NAME);
        } else if (element.getNode().getElementType() == CssElementTypes.CSS_ATKEYWORD) {
            CssHighlightingAnnotator.highlight(holder, element, CssElementTypes.CSS_KEYWORD, CssHighlighter.CSS_KEYWORD);
        }
    }

    private static void highlight(@NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull IElementType type, @NotNull TextAttributesKey defaultKey) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "highlight"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "highlight"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "highlight"));
        }
        if (defaultKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultKey", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "highlight"));
        }
        TextAttributesKey key = CssHighlightingAnnotator.getTextAttributesKey(element, type, defaultKey);
        String annotationMessage = ApplicationManager.getApplication().isUnitTestMode() ? key.getExternalName() : null;
        holder.createInfoAnnotation(element, annotationMessage).setTextAttributes(key);
    }

    private static TextAttributesKey getTextAttributesKey(@NotNull PsiElement element, @NotNull IElementType elementType, @NotNull TextAttributesKey defaultKey) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "getTextAttributesKey"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "getTextAttributesKey"));
        }
        if (defaultKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultKey", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "getTextAttributesKey"));
        }
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)element);
        if (language == null) {
            return defaultKey;
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)element.getProject(), (VirtualFile)file);
        Object[] keys = highlighter.getTokenHighlights(elementType);
        return ArrayUtil.isEmpty((Object[])keys) ? defaultKey : (TextAttributesKey)ArrayUtil.getLastElement((Object[])keys);
    }
}

