/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSelectorSuffixCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final CssSelectorSuffixType mySelectorSuffixType;
    @Nullable
    private final Condition<String> myFilter;

    public CssSelectorSuffixCompletionProvider(@NotNull CssSelectorSuffixType selectorSuffixType) {
        if (selectorSuffixType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffixType", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "<init>"));
        }
        this(selectorSuffixType, null);
    }

    public CssSelectorSuffixCompletionProvider(@NotNull CssSelectorSuffixType selectorSuffixType, @Nullable Condition<String> filter) {
        if (selectorSuffixType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffixType", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "<init>"));
        }
        this.mySelectorSuffixType = selectorSuffixType;
        this.myFilter = filter;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        GlobalSearchScope scope;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        PsiFile file = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)parameters.getOriginalFile());
        if (parameters.getInvocationCount() < 2) {
            scope = CssSelectorSuffixCompletionProvider.getCompletionScope(position, parameters.getOriginalFile());
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            result.addLookupAdvertisement("Press " + shortcutText + " again for selectors from all stylesheets");
        } else {
            scope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        }
        CssSelectorSuffix suffix = (CssSelectorSuffix)PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{CssSelectorSuffix.class});
        CssSelectorSuffix originalSuffix = suffix != null ? (CssSelectorSuffix)CompletionUtil.getOriginalOrSelf((PsiElement)suffix) : null;
        CssIndexUtil.processAllSelectorSuffixes(this.mySelectorSuffixType, project, scope, (PairProcessor<String, ? super CssSelectorSuffix>)((PairProcessor)(name, selectorSuffix) -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "lambda$addCompletions$0"));
            }
            if (StringUtil.isNotEmpty((String)name) && selectorSuffix != originalSuffix && (this.myFilter == null || this.myFilter.value(name))) {
                result.addElement(CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, (PsiElement)selectorSuffix, file));
            }
            return true;
        }));
        CssIndexUtil.processAmpersandSelectors(project, scope, (Processor<CssSelector>)((Processor)selector -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "lambda$addCompletions$1"));
            }
            for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                    ProgressIndicatorProvider.checkCanceled();
                    String suffixName = selectorSuffix.getName();
                    if (!StringUtil.isNotEmpty((String)suffixName) || this.mySelectorSuffixType != selectorSuffix.getType() || this.myFilter != null && !this.myFilter.value((Object)suffixName)) continue;
                    result.addElement(CssCompletionUtil.lookupForSelectorSuffix(suffixName, selectorSuffix, (PsiElement)selector, file));
                }
            }
            return true;
        }));
        GlobalSearchScope htmlScope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        CssIndexUtil.processSelectorNamesFromHtmlAttributes(project, htmlScope, (Processor<String>)((Processor)selectorSuffix -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "lambda$addCompletions$2"));
            }
            if (selectorSuffix.length() < 2 || this.myFilter != null && !this.myFilter.value(selectorSuffix)) {
                return true;
            }
            if (this.mySelectorSuffixType == CssSelectorSuffixType.CLASS && StringUtil.startsWithChar((CharSequence)selectorSuffix, (char)'.') || this.mySelectorSuffixType == CssSelectorSuffixType.ID && StringUtil.startsWithChar((CharSequence)selectorSuffix, (char)'#')) {
                String suffixName = selectorSuffix.substring(1);
                result.addElement(CssCompletionUtil.lookupForSelectorSuffixFromHtml(suffixName, this.mySelectorSuffixType, null, project));
            }
            return true;
        }));
    }

    @NotNull
    private static GlobalSearchScope getCompletionScope(@NotNull PsiElement position, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
        }
        Project project = position.getProject();
        if (file instanceof StylesheetFile && (virtualFile = file.getVirtualFile()) != null) {
            HashSet importedFiles = ContainerUtil.newHashSet((Object[])new VirtualFile[]{virtualFile});
            importedFiles.addAll(CssUtil.getImportedFiles(file, position, false));
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)importedFiles);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)file);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
        }
        return globalSearchScope;
    }
}

