/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssRuleset;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    public Language[] getLanguages() {
        return new Language[]{CSSLanguage.INSTANCE};
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/impl/util/editor/CssBreadcrumbsInfoProvider", "acceptElement"));
        }
        return (e instanceof CssRuleset || e instanceof CssAtRule) && e.isValid();
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/impl/util/editor/CssBreadcrumbsInfoProvider", "getElementInfo"));
        }
        if (e instanceof CssRuleset) {
            String string = ((CssRuleset)e).getPresentableText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        if (e instanceof CssAtRule) {
            ItemPresentation presentation = ((CssAtRule)e).getPresentation();
            String presentableText = presentation != null ? presentation.getPresentableText() : null;
            String string = presentableText != null ? presentableText : ((CssAtRule)e).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssBreadcrumbsInfoProvider", "getElementInfo"));
        }
        return "";
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/impl/util/editor/CssBreadcrumbsInfoProvider", "getElementTooltip"));
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }
}

