/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.application.options.editor.XmlFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssStylesheetElementTypeBase;
import com.intellij.psi.css.util.CssUriUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(final @NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement psiElement, final @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "buildLanguageFoldRegions"));
        }
        CssStylesheet stylesheet = CssFoldingBuilder.getStylesheet(psiElement);
        if (stylesheet == null) {
            return;
        }
        stylesheet.accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitCssBlock(CssBlock block) {
                TextRange textRange;
                if (!this.isOneLiner((PsiElement)block) && (textRange = block.getTextRange()).getLength() > 1) {
                    descriptors.add(CssFoldingBuilder.this.createDescriptor((PsiElement)block, textRange));
                }
                super.visitCssBlock(block);
            }

            public void visitCssUri(CssUri uri) {
                PsiElement valueElement = uri.getValueElement();
                if (CssUriUtil.isDataUri((PsiElement)uri) && valueElement != null) {
                    descriptors.add(CssFoldingBuilder.this.createDescriptor((PsiElement)uri, valueElement.getTextRange()));
                }
                super.visitCssUri(uri);
            }

            public void visitComment(PsiComment comment) {
                if (!this.isOneLiner((PsiElement)comment)) {
                    TextRange textRange = comment.getTextRange();
                    ASTNode node = comment.getNode();
                    if (textRange.getLength() >= 2 && node != null) {
                        descriptors.add(new FoldingDescriptor(node, textRange));
                    }
                }
                super.visitComment(comment);
            }

            public void visitAtRule(CssAtRule atRule) {
                ASTNode rBrace;
                ASTNode lBrace;
                ASTNode node = atRule.getNode();
                if (node != null && !this.isOneLiner((PsiElement)atRule) && (lBrace = node.findChildByType(CssElementTypes.CSS_LBRACE)) != null && (rBrace = node.findChildByType(CssElementTypes.CSS_RBRACE, lBrace)) != null) {
                    descriptors.add(new FoldingDescriptor(node, new TextRange(lBrace.getStartOffset(), rBrace.getStartOffset() + 1)));
                }
                super.visitAtRule(atRule);
            }

            private boolean isOneLiner(PsiElement element) {
                int endLine;
                TextRange textRange = element.getTextRange();
                int startLine = document.getLineNumber(textRange.getStartOffset());
                return startLine == (endLine = document.getLineNumber(textRange.getEndOffset() - 1));
            }
        });
    }

    protected FoldingDescriptor createDescriptor(PsiElement element, TextRange textRange) {
        return new FoldingDescriptor(element, textRange);
    }

    @Nullable
    protected static CssStylesheet getStylesheet(PsiElement psiElement) {
        if (psiElement instanceof StylesheetFile) {
            return ((StylesheetFile)psiElement).getStylesheet();
        }
        if (psiElement instanceof CssStylesheet) {
            return (CssStylesheet)psiElement;
        }
        return null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (node instanceof CssRuleset || node instanceof CssBlock || node.getElementType() == CssElementTypes.CSS_MEDIA) {
            return "{...}";
        }
        if (node instanceof PsiComment) {
            return "/*...*/";
        }
        if (CssUriUtil.isDataUri(node.getPsi())) {
            String value = ((CssUri)node).getValue();
            int firstSemicolonPosition = (value = StringUtil.stripQuotesAroundValue((String)value)).indexOf(";");
            return firstSemicolonPosition > 0 ? value.substring(0, firstSemicolonPosition) : "data";
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        return XmlFoldingSettings.getInstance().isCollapseDataUri() && CssUriUtil.isDataUri(node.getPsi());
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder", "isCustomFoldingRoot"));
        }
        return node.getElementType() instanceof CssStylesheetElementTypeBase;
    }
}

