/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssComposesClassReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssValueReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssUnresolvedClassInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration declaration) {
                if (!CssPropertyUtil.isComposesProperty(declaration) || declaration.getValue() == null) {
                    return;
                }
                CssTerm[] terms = declaration.getValue().getTerms();
                if (!CssUnresolvedClassInspection.isFilePathResolved(terms)) {
                    return;
                }
                for (CssTerm term : terms) {
                    CssUnresolvedClassInspection.checkTerm(holder, term);
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static void checkTerm(@NotNull ProblemsHolder holder, @NotNull CssTerm term) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "checkTerm"));
        }
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "checkTerm"));
        }
        PsiElement child = term.getFirstChild();
        PsiReference[] references = child.getReferences();
        for (int i = 0; i < references.length; ++i) {
            PsiReference reference = references[i];
            if (reference instanceof CssValueReference && reference.resolve() != null) {
                return;
            }
            if (!(reference instanceof CssComposesClassReference) || !ArrayUtil.isEmpty((Object[])((CssComposesClassReference)reference).multiResolve(false))) continue;
            for (int j = i + 1; j < references.length; ++j) {
                PsiReference otherReference = references[j];
                if (!(otherReference instanceof CssValueReference) || otherReference.resolve() == null) continue;
                return;
            }
            holder.registerProblem(child, ((CssComposesClassReference)reference).getUnresolvedMessagePattern(), new LocalQuickFix[0]);
        }
    }

    private static boolean isFilePathResolved(@NotNull CssTerm[] terms) {
        if (terms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terms", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "isFilePathResolved"));
        }
        CssTerm lastTerm = (CssTerm)ArrayUtil.getLastElement((Object[])terms);
        if (lastTerm == null) {
            return false;
        }
        return lastTerm.getTermType() != CssTermTypes.STRING || !ArrayUtil.isEmpty((Object[])CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild(), lastTerm.getContainingFile()));
    }
}

