/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.usages;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.usages.CssClassOrIdUsagesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;

public class CssSearchHelper {
    private CssSearchHelper() {
    }

    public static boolean isClassOrIdUsed(@NotNull CssSelectorSuffix selectorSuffix, @NotNull SearchScope scope) {
        if (selectorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/usages/CssSearchHelper", "isClassOrIdUsed"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/usages/CssSearchHelper", "isClassOrIdUsed"));
        }
        return CssSearchHelper.isUsed(selectorSuffix, scope);
    }

    private static boolean isUsed(@NotNull CssSelectorSuffix selectorSuffix, @NotNull SearchScope scope) {
        if (selectorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/usages/CssSearchHelper", "isUsed"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/usages/CssSearchHelper", "isUsed"));
        }
        if (selectorSuffix.isValid()) {
            boolean[] used = new boolean[]{false};
            Project project = selectorSuffix.getProject();
            String name = selectorSuffix.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project);
                PsiFile file = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)selectorSuffix);
                FileViewProvider viewProvider = file.getViewProvider();
                file = viewProvider.getPsi(viewProvider.getBaseLanguage());
                if (scope instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(name, (GlobalSearchScope)scope, file, ProgressManager.getInstance().getProgressIndicator()) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return true;
                }
                searchHelper.processElementsWithWord((current, offsetInElement) -> {
                    if (selectorSuffix == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/usages/CssSearchHelper", "lambda$isUsed$0"));
                    }
                    ProgressManager.checkCanceled();
                    if (used[0]) {
                        return false;
                    }
                    if (current instanceof CssTokenImpl) {
                        return true;
                    }
                    for (CssClassOrIdUsagesProvider usagesProvider : (CssClassOrIdUsagesProvider[])CssClassOrIdUsagesProvider.EXTENSION_POINT_NAME.getExtensions()) {
                        if (!usagesProvider.isUsage(selectorSuffix, current, offsetInElement)) continue;
                        used[0] = true;
                        return false;
                    }
                    return true;
                }, scope, name, (short)11, false);
                return used[0];
            }
        }
        return true;
    }
}

