/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsJavaCompilerNotNullableSerializer
extends JpsProjectExtensionSerializer {
    public static final List<String> DEFAULT_NOT_NULLS = Arrays.asList(NotNull.class.getName(), "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull");

    public JpsJavaCompilerNotNullableSerializer() {
        super("misc.xml", "NullableNotNullManager");
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerNotNullableSerializer", "loadExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerNotNullableSerializer", "loadExtension"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        ArrayList annoNames = ContainerUtil.newArrayList();
        for (Element option : componentTag.getChildren("option")) {
            if (!"myNotNulls".equals(option.getAttributeValue("name"))) continue;
            for (Element value : option.getChildren("value")) {
                for (Element list : value.getChildren("list")) {
                    for (Element item : list.getChildren("item")) {
                        ContainerUtil.addIfNotNull((Collection)annoNames, (Object)item.getAttributeValue("itemvalue"));
                    }
                }
            }
        }
        if (annoNames.isEmpty()) {
            annoNames.addAll(DEFAULT_NOT_NULLS);
        }
        configuration.setNotNullAnnotations((List)annoNames);
    }

    @Override
    public void loadExtensionWithDefaultSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerNotNullableSerializer", "loadExtensionWithDefaultSettings"));
        }
        JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).setNotNullAnnotations(DEFAULT_NOT_NULLS);
    }

    @Override
    public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerNotNullableSerializer", "saveExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerNotNullableSerializer", "saveExtension"));
        }
    }
}

