/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.xml.flows.converters;

import com.intellij.jsf.flows.FlowsCommonUtils;
import com.intellij.jsf.flows.FlowsPresentationUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowIdConverter
implements CustomReferenceConverter<Pair<PsiElement, String>> {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Pair<PsiElement, String>> value, PsiElement element, final ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element){

            @Nullable
            public PsiElement resolve() {
                String flowId = this.getValue();
                Module module = context.getModule();
                if (module == null) {
                    return null;
                }
                Pair<PsiElement, String> byName = FlowsCommonUtils.findFlowDefinitionByName(module, flowId);
                return byName == null ? null : (PsiElement)byName.getFirst();
            }

            @NotNull
            public Object[] getVariants() {
                Module module = context.getModule();
                if (module == null) {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/flows/converters/FlowIdConverter$1", "getVariants"));
                    }
                    return EMPTY_ARRAY;
                }
                HashSet elements = new HashSet();
                FlowsCommonUtils.processAllFlows((Processor<Pair<PsiElement, String>>)((Processor)arg_0 -> 1.lambda$getVariants$0((Set)elements, arg_0)), module);
                Object[] objectArray = ArrayUtil.toObjectArray((Collection)elements);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/flows/converters/FlowIdConverter$1", "getVariants"));
                }
                return objectArray;
            }

            private static /* synthetic */ boolean lambda$getVariants$0(Set elements, Pair pair) {
                PsiElement resolved = (PsiElement)pair.getFirst();
                if (resolved instanceof XmlElement) {
                    elements.add(FlowsPresentationUtils.createExplicitFlowLookupElement((String)pair.second));
                } else if (resolved instanceof PsiDirectory) {
                    elements.add(FlowsPresentationUtils.createImplicitFlowLookupElement((PsiDirectory)resolved));
                } else {
                    elements.add(FlowsPresentationUtils.createAnnotatedFlowLookupElement((String)pair.second));
                }
                return true;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/flows/converters/FlowIdConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

