/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries;

import com.intellij.jsf.references.libraries.providers.BooleanPsiReferenceProvider;
import com.intellij.jsf.references.libraries.providers.DoubleReferenceProvider;
import com.intellij.jsf.references.libraries.providers.FloatReferenceProvider;
import com.intellij.jsf.references.libraries.providers.IntegerReferenceProvider;
import com.intellij.jsf.references.libraries.providers.JsfWrappingPathReferenceProvider;
import com.intellij.jsf.references.libraries.providers.JsfWrappingPsiClassReferenceProvider;
import com.intellij.jsf.references.libraries.providers.LongReferenceProvider;
import com.intellij.jsf.references.libraries.providers.MultiVariantsPsiReferenceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfComponentLibraryReferenceProviderRegistry {
    private Map<String, Factory<PsiReferenceProvider>> myReferenceProviders = new HashMap();

    public static JsfComponentLibraryReferenceProviderRegistry getInstance() {
        return (JsfComponentLibraryReferenceProviderRegistry)ServiceManager.getService(JsfComponentLibraryReferenceProviderRegistry.class);
    }

    public JsfComponentLibraryReferenceProviderRegistry() {
        this.initProviders();
    }

    private void initProviders() {
        this.registerReferenceProvider("boolean", (Factory<PsiReferenceProvider>)((Factory)() -> BooleanPsiReferenceProvider.getInstance()));
        this.registerReferenceProvider("integer", (Factory<PsiReferenceProvider>)((Factory)() -> IntegerReferenceProvider.getInstance()));
        this.registerReferenceProvider("float", (Factory<PsiReferenceProvider>)((Factory)() -> FloatReferenceProvider.getInstance()));
        this.registerReferenceProvider("long", (Factory<PsiReferenceProvider>)((Factory)() -> LongReferenceProvider.getInstance()));
        this.registerReferenceProvider("double", (Factory<PsiReferenceProvider>)((Factory)() -> DoubleReferenceProvider.getInstance()));
        this.registerReferenceProvider(MultiVariantsPsiReferenceProvider.getProviderName(), (Factory<PsiReferenceProvider>)((Factory)() -> new MultiVariantsPsiReferenceProvider()));
        this.registerReferenceProvider("styleClass", (Factory<PsiReferenceProvider>)((Factory)() -> CssReferenceProviderUtil.CSS_CLASS_OR_ID_KEY_PROVIDER.getProvider()));
        this.registerReferenceProvider(JsfWrappingPsiClassReferenceProvider.getProviderName(), (Factory<PsiReferenceProvider>)((Factory)() -> new JsfWrappingPsiClassReferenceProvider()));
        this.registerReferenceProvider(JsfWrappingPathReferenceProvider.getProviderName(), (Factory<PsiReferenceProvider>)((Factory)() -> new JsfWrappingPathReferenceProvider()));
    }

    public void registerReferenceProvider(@NotNull String id, Factory<PsiReferenceProvider> provider) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/jsf/references/libraries/JsfComponentLibraryReferenceProviderRegistry", "registerReferenceProvider"));
        }
        this.myReferenceProviders.put(id, provider);
    }

    @Nullable
    public PsiReferenceProvider getReferenceProvider(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/jsf/references/libraries/JsfComponentLibraryReferenceProviderRegistry", "getReferenceProvider"));
        }
        Factory<PsiReferenceProvider> factory = this.myReferenceProviders.get(id);
        return factory == null ? null : (PsiReferenceProvider)factory.create();
    }
}

