/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiEquivalenceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.PsiEquivalenceUtil");

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, boolean areCommentsSignificant) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, new ReferenceComparator(resolvedElementsComparator), null, null, areCommentsSignificant);
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, @Nullable Comparator<PsiElement> leafElementsComparator) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, new ReferenceComparator(resolvedElementsComparator), leafElementsComparator, null, false);
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull Comparator<PsiReference> referenceComparator, @Nullable Comparator<PsiElement> leafElementsComparator, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        PsiElement[] children2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (referenceComparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceComparator", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element1 == element2) {
            return true;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren(element1, isElementSignificantCondition, areCommentsSignificant);
        if (children1.length != (children2 = PsiEquivalenceUtil.getFilteredChildren(element2, isElementSignificantCondition, areCommentsSignificant)).length) {
            return false;
        }
        for (int i2 = 0; i2 < children1.length; ++i2) {
            PsiElement child1 = children1[i2];
            PsiElement child2 = children2[i2];
            if (PsiEquivalenceUtil.areElementsEquivalent(child1, child2, referenceComparator, leafElementsComparator, isElementSignificantCondition, areCommentsSignificant)) continue;
            return false;
        }
        if (children1.length == 0 && (leafElementsComparator != null ? leafElementsComparator.compare(element1, element2) != 0 : !element1.textMatches(element2))) {
            return false;
        }
        PsiReference ref1 = element1.getReference();
        if (ref1 != null) {
            PsiReference ref2 = element2.getReference();
            if (ref2 == null) {
                return false;
            }
            if (referenceComparator.compare(ref1, ref2) != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, null, false);
    }

    @NotNull
    public static PsiElement[] getFilteredChildren(@NotNull PsiElement element, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/PsiEquivalenceUtil", "getFilteredChildren"));
        }
        ASTNode[] children1 = element.getNode().getChildren(null);
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode node : children1) {
            PsiElement child = node.getPsi();
            if (child instanceof PsiWhiteSpace || !areCommentsSignificant && child instanceof PsiComment || isElementSignificantCondition != null && !isElementSignificantCondition.value((Object)child)) continue;
            array.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/PsiEquivalenceUtil", "getFilteredChildren"));
        }
        return psiElementArray;
    }

    public static void findChildRangeDuplicates(PsiElement first, PsiElement last, List<Couple<PsiElement>> result, PsiElement scope) {
        PsiEquivalenceUtil.findChildRangeDuplicates(first, last, scope, (PairConsumer<PsiElement, PsiElement>)((PairConsumer)(start, end) -> result.add(Couple.of((Object)start, (Object)end))));
    }

    public static void findChildRangeDuplicates(PsiElement first, PsiElement last, PsiElement scope, PairConsumer<PsiElement, PsiElement> consumer) {
        LOG.assertTrue(first.getParent() == last.getParent());
        LOG.assertTrue(!(first instanceof PsiWhiteSpace) && !(last instanceof PsiWhiteSpace));
        PsiEquivalenceUtil.addRangeDuplicates(scope, first, last, consumer);
    }

    private static void addRangeDuplicates(PsiElement scope, PsiElement first, PsiElement last, PairConsumer<PsiElement, PsiElement> result) {
        PsiElement[] children = PsiEquivalenceUtil.getFilteredChildren(scope, null, true);
        int i2 = 0;
        block0: while (i2 < children.length) {
            PsiElement child = children[i2];
            if (child != first) {
                int j = i2;
                PsiElement next = first;
                while (PsiEquivalenceUtil.areElementsEquivalent(children[j], next)) {
                    ++j;
                    if (next == last) {
                        result.consume((Object)child, (Object)children[j - 1]);
                        i2 = j + 1;
                        continue block0;
                    }
                    next = PsiTreeUtil.skipSiblingsForward(next, PsiWhiteSpace.class);
                }
                if (i2 == j) {
                    PsiEquivalenceUtil.addRangeDuplicates(child, first, last, result);
                }
            }
            ++i2;
        }
    }

    private static class ReferenceComparator
    implements Comparator<PsiReference> {
        @Nullable
        private final Comparator<PsiElement> myResolvedElementsComparator;

        ReferenceComparator(@Nullable Comparator<PsiElement> resolvedElementsComparator) {
            this.myResolvedElementsComparator = resolvedElementsComparator;
        }

        @Override
        public int compare(PsiReference ref1, PsiReference ref2) {
            PsiElement resolved2;
            PsiElement resolved1 = ref1.resolve();
            return Comparing.equal((Object)resolved1, (Object)(resolved2 = ref2.resolve())) || this.myResolvedElementsComparator != null && this.myResolvedElementsComparator.compare(resolved1, resolved2) == 0 ? 0 : 1;
        }
    }
}

