/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownRunConfiguration
implements RunConfiguration,
WithoutOwnBeforeRunSteps {
    private final ConfigurationFactory myFactory;
    private Element myStoredElement;
    private String myName;
    private final Project myProject;
    private static final AtomicInteger myUniqueName = new AtomicInteger(1);
    private boolean myDoNotStore;

    public UnknownRunConfiguration(@NotNull ConfigurationFactory factory, @NotNull Project project) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/configurations/UnknownRunConfiguration", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/configurations/UnknownRunConfiguration", "<init>"));
        }
        this.myFactory = factory;
        this.myProject = project;
    }

    public void setDoNotStore(boolean b) {
        this.myDoNotStore = b;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isDoNotStore() {
        return this.myDoNotStore;
    }

    @Override
    public ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        UnknownSettingsEditor unknownSettingsEditor = new UnknownSettingsEditor();
        if (unknownSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/UnknownRunConfiguration", "getConfigurationEditor"));
        }
        return unknownSettingsEditor;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public RunConfiguration clone() {
        try {
            return (UnknownRunConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/configurations/UnknownRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/configurations/UnknownRunConfiguration", "getState"));
        }
        String factoryName = "";
        if (this.myStoredElement != null) {
            factoryName = this.myStoredElement.getAttributeValue("type");
        }
        throw new ExecutionException("Unknown run configuration type" + (factoryName.isEmpty() ? "" : " " + factoryName));
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            this.myName = String.format("Unknown%s", myUniqueName.getAndAdd(1));
        }
        return this.myName;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        throw new RuntimeConfigurationException("Broken configuration due to unavailable plugin or invalid configuration data.");
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.myStoredElement = element.clone();
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myStoredElement != null) {
            for (Attribute a : this.myStoredElement.getAttributes()) {
                element.setAttribute(a.getName(), a.getValue());
            }
            for (Element child : this.myStoredElement.getChildren()) {
                element.addContent(child.clone());
            }
        }
    }

    private static class UnknownSettingsEditor
    extends SettingsEditor<UnknownRunConfiguration> {
        private final JPanel myPanel = new JPanel();

        private UnknownSettingsEditor() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 50, 0));
            this.myPanel.add(new JLabel("This configuration cannot be edited", 0));
        }

        @Override
        protected void resetEditorFrom(@NotNull UnknownRunConfiguration s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/configurations/UnknownRunConfiguration$UnknownSettingsEditor", "resetEditorFrom"));
            }
        }

        @Override
        protected void applyEditorTo(@NotNull UnknownRunConfiguration s) throws ConfigurationException {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/configurations/UnknownRunConfiguration$UnknownSettingsEditor", "applyEditorTo"));
            }
        }

        @Override
        @NotNull
        protected JComponent createEditor() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/UnknownRunConfiguration$UnknownSettingsEditor", "createEditor"));
            }
            return jPanel;
        }
    }
}

