/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.DashboardListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.Topic;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public interface RunDashboardManager {
    public static final Topic<DashboardListener> DASHBOARD_TOPIC = Topic.create((String)"run dashboard", DashboardListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public static RunDashboardManager getInstance(Project project) {
        return ServiceManager.getService(project, RunDashboardManager.class);
    }

    public ContentManager getDashboardContentManager();

    public String getToolWindowId();

    public Icon getToolWindowIcon();

    public boolean isToolWindowAvailable();

    public void createToolWindowContent(@NotNull ToolWindow var1);

    public List<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> getRunConfigurations();

    public boolean isShowConfigurations();

    public void setShowConfigurations(boolean var1);
}

