/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamService {
    private static final Map<SemKey, SemKey<JamMemberMeta>> ourMetaKeys = ContainerUtil.newHashMap();
    public static final SemKey<JamMemberMeta> MEMBER_META_KEY = SemKey.createKey("JamMemberMeta", new SemKey[0]);
    public static final SemKey<JamAnnotationMeta> ANNO_META_KEY = SemKey.createKey("JamAnnotationMeta", new SemKey[0]);
    public static final SemKey<JamElement> JAM_ELEMENT_KEY = SemKey.createKey("JamElement", new SemKey[0]);
    public static final SemKey<JamElement> JAM_ALIASING_ELEMENT_KEY = SemKey.createKey("JamAliasingElement", new SemKey[0]);
    public static final SemKey<JamMemberMeta> ALIASING_MEMBER_META_KEY = JamService.getMetaKey(JAM_ALIASING_ELEMENT_KEY);
    private final PsiManager myPsiManager;
    private final SemService mySemService;

    protected JamService(PsiManager psiManager, SemService semService) {
        this.myPsiManager = psiManager;
        this.mySemService = semService;
    }

    public static JamService getJamService(Project p) {
        return ServiceManager.getService(p, JamService.class);
    }

    private static void processMembers(PsiClass psiClass, boolean checkClass, boolean checkMethods, boolean checkFields, boolean checkDeep, Processor<PsiMember> processor) {
        if (checkClass) {
            if (checkDeep) {
                for (PsiClass curClass : JamCommonUtil.getSuperClassList(psiClass)) {
                    processor.process((Object)curClass);
                }
            } else {
                processor.process((Object)psiClass);
            }
        }
        if (checkMethods) {
            ContainerUtil.process(Arrays.asList(checkDeep ? psiClass.getAllMethods() : psiClass.getMethods()), processor);
        }
        if (checkFields) {
            ContainerUtil.process(Arrays.asList(checkDeep ? psiClass.getAllFields() : psiClass.getFields()), processor);
        }
    }

    @Deprecated
    @Nullable
    public <T extends JamElement> T getJamElement(Class<T> key, PsiElement psi) {
        for (JamElement element : this.mySemService.getSemElements(JAM_ELEMENT_KEY, psi)) {
            if (!key.isInstance(element)) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public <T extends JamElement> T getJamElement(@NotNull PsiElement psi, JamMemberMeta<? extends PsiModifierListOwner, ? extends T> ... metas) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/jam/JamService", "getJamElement"));
        }
        for (JamMemberMeta<PsiModifierListOwner, T> jamMemberMeta : metas) {
            JamElement element = (JamElement)this.mySemService.getSemElement(jamMemberMeta.getJamKey(), psi);
            if (element == null) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public <T extends JamElement> T getJamElement(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/jam/JamService", "getJamElement"));
        }
        if (!psi.isValid()) {
            throw new PsiInvalidElementAccessException(psi);
        }
        try {
            return (T)((JamElement)this.mySemService.getSemElement(key, psi));
        }
        catch (PsiInvalidElementAccessException e) {
            throw new RuntimeException("Element invalidated: old=" + psi + "; new=" + e.getPsiElement(), e);
        }
    }

    @NotNull
    public <T extends PsiModifierListOwner> List<JamMemberMeta> getMetas(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/jam/JamService", "getMetas"));
        }
        List<JamMemberMeta> list = this.mySemService.getSemElements(MEMBER_META_KEY, psi);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamService", "getMetas"));
        }
        return list;
    }

    @Nullable
    public <T extends PsiModifierListOwner> JamMemberMeta<T, ?> getMeta(@NotNull T psi, SemKey<? extends JamMemberMeta<T, ?>> key) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/jam/JamService", "getMeta"));
        }
        return this.mySemService.getSemElement(key, psi);
    }

    @Nullable
    public JamAnnotationMeta getMeta(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/jam/JamService", "getMeta"));
        }
        return this.mySemService.getSemElement(ANNO_META_KEY, anno);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamMemberMeta<? super PsiClass, T> meta, @NonNls String anno, GlobalSearchScope scope) {
        return this.getJamClassElements(meta.getJamKey(), anno, scope);
    }

    public <T extends JamElement> List<T> getJamMethodElements(JamMemberMeta<? super PsiMethod, T> meta, @NonNls String anno, GlobalSearchScope scope) {
        return this.getJamMethodElements(meta.getJamKey(), anno, scope);
    }

    public <T extends JamElement> List<T> getJamFieldElements(JamMemberMeta<? super PsiField, T> meta, @NonNls String anno, GlobalSearchScope scope) {
        return this.getJamFieldElements(meta.getJamKey(), anno, scope);
    }

    public <T extends JamElement> List<T> getAnnotatedMembersList(@NotNull PsiClass psiClass, boolean checkClass, boolean checkMethods, boolean checkFields, boolean checkDeep, JamMemberMeta<? extends PsiMember, ? extends T> ... metas) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/jam/JamService", "getAnnotatedMembersList"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        JamService.processMembers(psiClass, checkClass, checkMethods, checkFields, checkDeep, (Processor<PsiMember>)((Processor)member -> {
            for (JamMemberMeta meta : metas) {
                ContainerUtil.addIfNotNull((Collection)result, this.mySemService.getSemElement(meta.getJamKey(), (PsiElement)member));
            }
            return true;
        }));
        return result;
    }

    public <T extends JamElement> List<T> getJamClassElements(SemKey<T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        JamCommonUtil.findAnnotatedElements(PsiClass.class, anno, this.myPsiManager, scope, psiMember -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiMember));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getJamMethodElements(SemKey<T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        JamCommonUtil.findAnnotatedElements(PsiMethod.class, anno, this.myPsiManager, scope, psiMember -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiMember));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getJamFieldElements(SemKey<T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        JamCommonUtil.findAnnotatedElements(PsiField.class, anno, this.myPsiManager, scope, psiMember -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiMember));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getJamParameterElements(SemKey<T> key, @NonNls String anno, GlobalSearchScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        JamCommonUtil.findAnnotatedElements(PsiParameter.class, anno, this.myPsiManager, scope, psiParameter -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(key, (PsiElement)psiParameter));
            return true;
        });
        return result;
    }

    public <T extends JamElement> List<T> getAnnotatedMembersList(@NotNull PsiClass psiClass, SemKey<T> clazz, boolean checkClass, boolean checkMethods, boolean checkFields, boolean checkDeep) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/jam/JamService", "getAnnotatedMembersList"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        JamService.processMembers(psiClass, checkClass, checkMethods, checkFields, checkDeep, (Processor<PsiMember>)((Processor)member -> {
            ContainerUtil.addIfNotNull((Collection)result, this.getJamElement(clazz, (PsiElement)member));
            return true;
        }));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SemKey<JamMemberMeta> getMetaKey(SemKey<? extends JamElement> jamKey) {
        Map<SemKey, SemKey<JamMemberMeta>> map = ourMetaKeys;
        synchronized (map) {
            SemKey result = ourMetaKeys.get(jamKey);
            if (result == null) {
                Object[] jamSupers = jamKey.getSupers();
                SemKey[] metaSupers = (SemKey[])ContainerUtil.map2Array((Object[])jamSupers, SemKey.class, key -> JamService.getMetaKey(key));
                result = MEMBER_META_KEY.subKey(jamKey + "Meta", metaSupers);
                ourMetaKeys.put(jamKey, result);
            }
            return result;
        }
    }
}

