/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.ref.AnnotationAttributeChildLink;
import com.intellij.util.xml.MutableGenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamStringAttributeElement<T>
extends JamAttributeElement<T>
implements MutableGenericValue<T> {
    private final JamConverter<T> myConverter;

    public JamStringAttributeElement(@NotNull PsiElementRef<PsiAnnotation> parent, String attributeName, JamConverter<T> converter) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/JamStringAttributeElement", "<init>"));
        }
        super(attributeName, parent);
        this.myConverter = converter;
    }

    public JamStringAttributeElement(@NotNull PsiAnnotationMemberValue exactValue, JamConverter<T> converter) {
        if (exactValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exactValue", "com/intellij/jam/JamStringAttributeElement", "<init>"));
        }
        super(exactValue);
        this.myConverter = converter;
    }

    @Override
    public String getStringValue() {
        PsiAnnotationMemberValue value = this.getPsiElement();
        if (value == null) {
            return null;
        }
        return JamCommonUtil.getObjectValue(value, String.class);
    }

    @Nullable
    public PsiLiteral getPsiLiteral() {
        PsiAnnotationMemberValue value = this.getPsiElement();
        return value instanceof PsiLiteral ? (PsiLiteral)value : null;
    }

    @Override
    public T getValue() {
        return this.myConverter.fromString(this.getStringValue(), this);
    }

    public JamConverter<T> getConverter() {
        return this.myConverter;
    }

    @Override
    public void setStringValue(@Nullable String value) {
        PsiAnnotationMemberValue existing = this.getPsiElement();
        if (value == null && existing == null) {
            return;
        }
        PsiAnnotation annotation = this.getParentAnnotationElement().ensurePsiElementExists();
        PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
        assert (support != null);
        PsiLiteral valueElement = value == null ? null : support.createLiteralValue(value, annotation);
        AnnotationAttributeChildLink attributeLink = this.getAttributeLink();
        if (attributeLink != null) {
            annotation.setDeclaredAttributeValue(attributeLink.getAttributeName(), valueElement);
        } else if (valueElement != null) {
            existing.replace(valueElement);
        } else {
            PsiElement parent = existing.getParent();
            (parent instanceof PsiNameValuePair ? parent : existing).delete();
        }
    }

    @Override
    public void setValue(T value) {
        String s = this.myConverter.toString(value, this);
        this.setStringValue(s);
    }
}

