/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamClassGenerator;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.patterns.ElementPattern;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamMemberMeta<Psi extends PsiModifierListOwner, Jam extends JamElement>
extends JamMemberArchetype<Psi, Jam>
implements SemElement {
    private final SemKey<Jam> myJamKey;
    private final SemKey<JamMemberMeta> myMetaKey;
    private final NotNullFunction<PsiElementRef, ? extends Jam> myCreator;
    private final List<JamAnnotationMeta> myRootAnnos = new ArrayList<JamAnnotationMeta>(1);

    protected JamMemberMeta(Class<? extends Jam> jamClass) {
        this(null, jamClass);
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, Class<? extends Jam> jamClass) {
        this(parent, jamClass, JamService.JAM_ELEMENT_KEY.subKey(jamClass.getSimpleName(), new SemKey[0]));
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, Class<? extends Jam> jamClass, SemKey<Jam> jamKey) {
        super(parent);
        this.myJamKey = jamKey;
        this.myCreator = JamClassGenerator.getInstance().generateJamElementFactory(jamClass);
        this.myMetaKey = JamService.getMetaKey(this.myJamKey);
    }

    public SemKey<Jam> getJamKey() {
        return this.myJamKey;
    }

    public SemKey<JamMemberMeta> getMetaKey() {
        return this.myMetaKey;
    }

    public List<JamAnnotationMeta> getRootAnnotations() {
        return this.myRootAnnos;
    }

    public void register(SemRegistrar registrar, ElementPattern<? extends Psi> pattern) {
        registrar.registerSemElementProvider(this.myMetaKey, pattern, new ConstantFunction((Object)this));
        registrar.registerSemElementProvider(this.myJamKey, pattern, psi -> this.createJamElement(PsiElementRef.real(psi)));
        this.registerChildren(registrar, pattern);
        for (JamMemberArchetype cur = this; cur != null; cur = cur.getParent()) {
            for (JamAnnotationMeta anno : cur.getAnnotations()) {
                anno.registerTopLevelSem(registrar, pattern, this);
            }
        }
    }

    @Override
    public JamMemberMeta<Psi, Jam> addPomTargetProducer(@NotNull PairConsumer<Jam, Consumer<PomTarget>> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/jam/reflect/JamMemberMeta", "addPomTargetProducer"));
        }
        super.addPomTargetProducer(producer);
        return this;
    }

    @Nullable
    public final Jam getJamElement(@NotNull Psi member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamMemberMeta", "getJamElement"));
        }
        return (Jam)((JamElement)SemService.getSemService(member.getProject()).getSemElement(this.myJamKey, (PsiElement)member));
    }

    @Nullable
    public Jam createJamElement(PsiElementRef<Psi> ref) {
        return (Jam)((JamElement)this.myCreator.fun(ref));
    }

    @Override
    public JamMemberMeta<Psi, Jam> addAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        return this;
    }

    public JamMemberMeta<Psi, Jam> addRootAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        this.myRootAnnos.add(meta);
        return this;
    }
}

