/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CopyingCompiler
implements PackagingCompiler {
    public abstract VirtualFile[] getFilesToCopy(CompileContext var1);

    public abstract String getDestinationPath(VirtualFile var1);

    @Override
    public final void processOutdatedItem(CompileContext context, String url, @Nullable ValidityState state) {
        if (state != null) {
            String destinationPath = ((DestinationFileInfo)state).getDestinationPath();
            new File(destinationPath).delete();
        }
    }

    @Override
    @NotNull
    public final FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ReadAction.compute(() -> {
            VirtualFile[] filesToCopy = this.getFilesToCopy(context);
            FileProcessingCompiler.ProcessingItem[] items = new FileProcessingCompiler.ProcessingItem[filesToCopy.length];
            for (int idx = 0; idx < filesToCopy.length; ++idx) {
                VirtualFile file = filesToCopy[idx];
                items[idx] = new CopyItem(file, this.getDestinationPath(file));
            }
            return items;
        });
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/CopyingCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    @Override
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        ArrayList<CopyItem> successfullyProcessed = new ArrayList<CopyItem>(items.length);
        for (FileProcessingCompiler.ProcessingItem item : items) {
            CopyItem copyItem = (CopyItem)item;
            String fromPath = copyItem.getSourcePath();
            String toPath = copyItem.getDestinationPath();
            try {
                FileUtil.copy((File)new File(fromPath), (File)new File(toPath));
                successfullyProcessed.add(copyItem);
            }
            catch (IOException e) {
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message("error.copying", fromPath, toPath, e.getMessage()), null, -1, -1);
            }
        }
        return successfullyProcessed.toArray(new FileProcessingCompiler.ProcessingItem[successfullyProcessed.size()]);
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = CompilerBundle.message("file.copying.compiler.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/CopyingCompiler", "getDescription"));
        }
        return string;
    }

    @Override
    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    @Override
    public ValidityState createValidityState(DataInput in) throws IOException {
        return new DestinationFileInfo(IOUtil.readString((DataInput)in), true);
    }

    private static class DestinationFileInfo
    implements ValidityState {
        private final String destinationPath;
        private final boolean myFileExists;

        public DestinationFileInfo(String destinationPath, boolean fileExists) {
            this.destinationPath = destinationPath;
            this.myFileExists = fileExists;
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof DestinationFileInfo)) {
                return false;
            }
            DestinationFileInfo destinationFileInfo = (DestinationFileInfo)otherState;
            return this.myFileExists == destinationFileInfo.myFileExists && this.destinationPath.equals(destinationFileInfo.destinationPath);
        }

        @Override
        public void save(DataOutput out) throws IOException {
            IOUtil.writeString((String)this.destinationPath, (DataOutput)out);
        }

        public String getDestinationPath() {
            return this.destinationPath;
        }
    }

    private static class CopyItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile myFile;
        private final DestinationFileInfo myInfo;
        private final String mySourcePath;

        public CopyItem(VirtualFile file, String destinationPath) {
            this.myFile = file;
            this.mySourcePath = file.getPath().replace('/', File.separatorChar);
            this.myInfo = new DestinationFileInfo(destinationPath, new File(destinationPath).exists());
        }

        @Override
        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile2 = this.myFile;
            if (virtualFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/CopyingCompiler$CopyItem", "getFile"));
            }
            return virtualFile2;
        }

        @Override
        public ValidityState getValidityState() {
            return this.myInfo;
        }

        public String getSourcePath() {
            return this.mySourcePath;
        }

        public String getDestinationPath() {
            return this.myInfo.getDestinationPath();
        }
    }
}

