/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorColorPalette {
    protected final EditorColorsScheme myColorsScheme;
    private final MultiMap<Color, TextAttributesKey> myColors = MultiMap.createSmart();
    public static final Comparator<Color> ORDER_NONE = Comparator.comparingInt(EditorColorPalette::getDefaultOrder);
    public static final Comparator<Color> ORDER_BY_INTENSITY = Comparator.comparingInt(EditorColorPalette::getIntensity);

    public EditorColorPalette(EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    public EditorColorPalette withBackgroundColors() {
        return this.collectColors((Function<TextAttributes, Color>)((Function)attr -> attr.getBackgroundColor()));
    }

    public EditorColorPalette withForegroundColors() {
        return this.collectColors((Function<TextAttributes, Color>)((Function)attr -> attr.getForegroundColor()));
    }

    private Collection<Color> orderBy(@Nullable Comparator<Color> comparator) {
        ArrayList<Color> sorted = new ArrayList<Color>();
        sorted.addAll(this.myColors.keySet());
        Collections.sort(sorted, comparator);
        return sorted;
    }

    private static int getIntensity(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/colors/EditorColorPalette", "getIntensity"));
        }
        return (color.getRed() + color.getGreen() + color.getBlue()) / 3;
    }

    @Contract(pure=true)
    private static int getDefaultOrder(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/colors/EditorColorPalette", "getDefaultOrder"));
        }
        return 0;
    }

    public Collection<Color> getColors(@NotNull Comparator<Color> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/openapi/editor/colors/EditorColorPalette", "getColors"));
        }
        return comparator == ORDER_NONE ? this.myColors.keySet() : this.orderBy(comparator);
    }

    @NotNull
    public Set<Map.Entry<Color, Collection<TextAttributesKey>>> getEntries() {
        Set set = this.myColors.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/EditorColorPalette", "getEntries"));
        }
        return set;
    }

    public EditorColorPalette collectColors(@NotNull Function<TextAttributes, Color> attrColorReader) {
        if (attrColorReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrColorReader", "com/intellij/openapi/editor/colors/EditorColorPalette", "collectColors"));
        }
        return this.collectColorsWithFilter(attrColorReader, false);
    }

    public EditorColorPalette collectColorsWithFilter(@NotNull Function<TextAttributes, Color> attrColorReader, boolean filterOutRainbowAttrKeys) {
        if (attrColorReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrColorReader", "com/intellij/openapi/editor/colors/EditorColorPalette", "collectColorsWithFilter"));
        }
        MultiMap colors = MultiMap.createSmart();
        for (TextAttributesKey key : this.getTextAttributeKeys(filterOutRainbowAttrKeys)) {
            Color usedColor;
            TextAttributes attributes = this.myColorsScheme.getAttributes(key);
            if (attributes == null || (usedColor = (Color)attrColorReader.fun((Object)attributes)) == null) continue;
            colors.putValue((Object)usedColor, (Object)key);
        }
        this.myColors.putAllValues(colors);
        return this;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor) {
        if (sampleColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleColor", "com/intellij/openapi/editor/colors/EditorColorPalette", "getClosestNonConflictingColor"));
        }
        boolean searchBrighter = ColorUtil.isDark((Color)sampleColor);
        Color foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(searchBrighter));
        if (foundColor == null) {
            foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(!searchBrighter));
        }
        return foundColor;
    }

    @Contract(pure=true)
    private static Function<Color, Color> getAdjuster(boolean searchBrighter) {
        return searchBrighter ? Color::brighter : Color::darker;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor, @NotNull Function<Color, Color> colorAdjuster) {
        if (sampleColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleColor", "com/intellij/openapi/editor/colors/EditorColorPalette", "getClosestNonConflictingColor"));
        }
        if (colorAdjuster == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorAdjuster", "com/intellij/openapi/editor/colors/EditorColorPalette", "getClosestNonConflictingColor"));
        }
        if (this.myColors.containsKey((Object)sampleColor)) {
            Color newColor = (Color)colorAdjuster.fun((Object)sampleColor);
            return !sampleColor.equals(newColor) ? this.getClosestNonConflictingColor(newColor, colorAdjuster) : null;
        }
        return sampleColor;
    }

    protected abstract Collection<TextAttributesKey> getTextAttributeKeys(boolean var1);
}

