/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="ExternalSystemSettings")
public class ExternalSystemTaskExecutionSettings
implements Cloneable {
    @NotNull
    @NonNls
    public static final String TAG_NAME = "ExternalSystemSettings";
    @NotNull
    @NonNls
    public static final Key<ParametersList> JVM_AGENT_SETUP_KEY = Key.create((String)"jvmAgentSetup");
    private List<String> myTaskNames = ContainerUtilRt.newArrayList();
    private List<String> myTaskDescriptions = ContainerUtilRt.newArrayList();
    @Nullable
    private String myExecutionName;
    private String myExternalSystemIdString;
    private String myExternalProjectPath;
    private String myVmOptions;
    private String myScriptParameters;
    private Map<String, String> myEnv = ContainerUtilRt.newHashMap();
    private boolean myPassParentEnvs = true;

    @Nullable
    public String getExecutionName() {
        return this.myExecutionName;
    }

    public void setExecutionName(@Nullable String executionName) {
        this.myExecutionName = executionName;
    }

    public String getExternalSystemIdString() {
        return this.myExternalSystemIdString;
    }

    public ProjectSystemId getExternalSystemId() {
        return new ProjectSystemId(this.myExternalSystemIdString);
    }

    public void setExternalSystemIdString(String externalSystemIdString) {
        this.myExternalSystemIdString = externalSystemIdString;
    }

    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void setExternalProjectPath(String externalProjectPath) {
        this.myExternalProjectPath = externalProjectPath;
    }

    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    public void setTaskNames(List<String> taskNames) {
        this.myTaskNames = taskNames;
    }

    public List<String> getTaskDescriptions() {
        return this.myTaskDescriptions;
    }

    public void setTaskDescriptions(List<String> taskDescriptions) {
        this.myTaskDescriptions = taskDescriptions;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = this.myEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/execution/ExternalSystemTaskExecutionSettings", "getEnv"));
        }
        return map;
    }

    public void setEnv(Map<String, String> env) {
        this.myEnv = env == null ? ContainerUtilRt.newHashMap() : env;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    public ExternalSystemTaskExecutionSettings clone() {
        ExternalSystemTaskExecutionSettings result = new ExternalSystemTaskExecutionSettings();
        result.setExecutionName(this.getExecutionName());
        result.setExternalSystemIdString(this.getExternalSystemIdString());
        result.setExternalProjectPath(this.getExternalProjectPath());
        result.setVmOptions(this.getVmOptions());
        result.setScriptParameters(this.getScriptParameters());
        result.setTaskNames(ContainerUtilRt.newArrayList(this.getTaskNames()));
        result.setTaskDescriptions(ContainerUtilRt.newArrayList(this.getTaskDescriptions()));
        result.setEnv(ContainerUtilRt.newHashMap(this.getEnv()));
        result.setPassParentEnvs(this.isPassParentEnvs());
        return result;
    }

    public int hashCode() {
        int result = this.myTaskNames != null ? this.myTaskNames.hashCode() : 0;
        result = 31 * result + (this.myExecutionName != null ? this.myExecutionName.hashCode() : 0);
        result = 31 * result + (this.myExternalSystemIdString != null ? this.myExternalSystemIdString.hashCode() : 0);
        result = 31 * result + (this.myExternalProjectPath != null ? this.myExternalProjectPath.hashCode() : 0);
        result = 31 * result + (this.myVmOptions != null ? this.myVmOptions.hashCode() : 0);
        result = 31 * result + (this.myScriptParameters != null ? this.myScriptParameters.hashCode() : 0);
        result = 31 * result + (this.myEnv != null ? this.myEnv.hashCode() : 0);
        result = 31 * result + (this.myPassParentEnvs ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskExecutionSettings settings = (ExternalSystemTaskExecutionSettings)o;
        if (this.myExecutionName != null ? !this.myExecutionName.equals(settings.myExecutionName) : settings.myExecutionName != null) {
            return false;
        }
        if (this.myExternalProjectPath != null ? !this.myExternalProjectPath.equals(settings.myExternalProjectPath) : settings.myExternalProjectPath != null) {
            return false;
        }
        if (this.myExternalSystemIdString != null ? !this.myExternalSystemIdString.equals(settings.myExternalSystemIdString) : settings.myExternalSystemIdString != null) {
            return false;
        }
        if (this.myTaskNames != null ? !this.myTaskNames.equals(settings.myTaskNames) : settings.myTaskNames != null) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myVmOptions) ^ StringUtil.isEmpty((String)settings.myVmOptions)) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myScriptParameters) ^ StringUtil.isEmpty((String)settings.myScriptParameters)) {
            return false;
        }
        if (this.myEnv != null ? !this.myEnv.equals(settings.myEnv) : settings.myEnv != null) {
            return false;
        }
        return this.myPassParentEnvs == settings.myPassParentEnvs;
    }

    public String toString() {
        return (this.myTaskNames == null ? "" : StringUtil.join(this.myTaskNames, (String)" ")) + (StringUtil.isEmpty((String)this.myScriptParameters) ? "" : " " + this.myScriptParameters) + (StringUtil.isEmpty((String)this.myVmOptions) ? "" : " " + this.myVmOptions);
    }
}

