/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.ParametersEnhancer;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ArtifactInfo;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemApiUtil {
    private static final String LAST_USED_PROJECT_PATH_PREFIX = "LAST_EXTERNAL_PROJECT_PATH_";
    @NotNull
    public static final String PATH_SEPARATOR = "/";
    @NotNull
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(?:.*/)?(.+?)(?:-([\\d+](?:\\.[\\d]+)*))?(?:\\.[^\\.]+?)?");
    @NotNull
    public static final Comparator<Object> ORDER_AWARE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(@NotNull Object o1, @NotNull Object o2) {
            int order2;
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil$1", "compare"));
            }
            int order1 = this.getOrder(o1);
            return order1 < (order2 = this.getOrder(o2)) ? -1 : (order1 == order2 ? 0 : 1);
        }

        private int getOrder(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil$1", "getOrder"));
            }
            ArrayDeque toCheck = new ArrayDeque();
            toCheck.add(o.getClass());
            while (!toCheck.isEmpty()) {
                Class clazz = (Class)toCheck.poll();
                Order annotation = clazz.getAnnotation(Order.class);
                if (annotation != null) {
                    return annotation.value();
                }
                Class c = clazz.getSuperclass();
                if (c != null) {
                    toCheck.add(c);
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                Collections.addAll(toCheck, interfaces);
            }
            return 1000;
        }
    };
    @NotNull
    private static final NullableFunction<DataNode<?>, Key<?>> GROUPER = node -> node.getKey();
    @NotNull
    private static final TransferToEDTQueue<Runnable> TRANSFER_TO_EDT_QUEUE = new TransferToEDTQueue("External System queue", runnable -> {
        runnable.run();
        return true;
    }, Conditions.alwaysFalse(), 300);

    private ExternalSystemApiUtil() {
    }

    @NotNull
    public static String extractNameFromPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "extractNameFromPath"));
        }
        String strippedPath = ExternalSystemApiUtil.stripPath(path2);
        int i2 = strippedPath.lastIndexOf(PATH_SEPARATOR);
        String result = i2 < 0 || i2 >= strippedPath.length() - 1 ? strippedPath : strippedPath.substring(i2 + 1);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "extractNameFromPath"));
        }
        return string;
    }

    @NotNull
    private static String stripPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "stripPath"));
        }
        String[] endingsToStrip = new String[]{PATH_SEPARATOR, "!", ".jar"};
        StringBuilder buffer = new StringBuilder(path2);
        for (String ending : endingsToStrip) {
            if (buffer.lastIndexOf(ending) != buffer.length() - ending.length()) continue;
            buffer.setLength(buffer.length() - ending.length());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "stripPath"));
        }
        return string;
    }

    @NotNull
    public static String getLibraryName(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLibraryName"));
        }
        String result = library.getName();
        if (result != null) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLibraryName"));
            }
            return string;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(type)) {
                String candidate = ExternalSystemApiUtil.extractNameFromPath(url);
                if (StringUtil.isEmpty((String)candidate)) continue;
                String string = candidate;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLibraryName"));
                }
                return string;
            }
        }
        assert (false);
        if ("unknown-lib" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLibraryName"));
        }
        return "unknown-lib";
    }

    public static boolean isRelated(@NotNull Library library, @NotNull LibraryData libraryData) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isRelated"));
        }
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isRelated"));
        }
        return ExternalSystemApiUtil.getLibraryName(library).equals(libraryData.getInternalName());
    }

    public static boolean isExternalSystemLibrary(@NotNull Library library, @NotNull ProjectSystemId externalSystemId) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isExternalSystemLibrary"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isExternalSystemLibrary"));
        }
        return library.getName() != null && StringUtil.startsWith((CharSequence)library.getName(), (CharSequence)(externalSystemId.getReadableName() + ": "));
    }

    @Nullable
    public static ArtifactInfo parseArtifactInfo(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "parseArtifactInfo"));
        }
        Matcher matcher = ARTIFACT_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return new ArtifactInfo(matcher.group(1), null, matcher.group(2));
    }

    public static void orderAwareSort(@NotNull List<?> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "orderAwareSort"));
        }
        Collections.sort(data, ORDER_AWARE_COMPARATOR);
    }

    @NotNull
    public static String toCanonicalPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "toCanonicalPath"));
        }
        String p = ExternalSystemApiUtil.normalizePath(new File(path2).getAbsolutePath());
        assert (p != null);
        String string = PathUtil.getCanonicalPath(p);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "toCanonicalPath"));
        }
        return string;
    }

    @NotNull
    public static String getLocalFileSystemPath(@NotNull VirtualFile file) {
        VirtualFile jar;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLocalFileSystemPath"));
        }
        if (file.getFileType() == FileTypes.ARCHIVE && (jar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            String string = jar.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLocalFileSystemPath"));
            }
            return string;
        }
        String string = ExternalSystemApiUtil.toCanonicalPath(file.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLocalFileSystemPath"));
        }
        return string;
    }

    @Nullable
    public static ExternalSystemManager<?, ?, ?, ?, ?> getManager(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getManager"));
        }
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals(manager.getSystemId())) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public static Collection<ExternalSystemManager<?, ?, ?, ?, ?>> getAllManagers() {
        ArrayList result = ContainerUtilRt.newArrayList();
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            result.add(manager);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getAllManagers"));
        }
        return arrayList;
    }

    public static MultiMap<Key<?>, DataNode<?>> recursiveGroup(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "recursiveGroup"));
        }
        ContainerUtil.KeyOrderedMultiMap result = new ContainerUtil.KeyOrderedMultiMap();
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(nodes);
        while (!queue.isEmpty()) {
            Collection _nodes = (Collection)queue.remove();
            result.putAllValues(ExternalSystemApiUtil.group(_nodes));
            for (DataNode _node : _nodes) {
                queue.add(_node.getChildren());
            }
        }
        return result;
    }

    @NotNull
    public static MultiMap<Key<?>, DataNode<?>> group(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "group"));
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, GROUPER);
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "group"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<DataNode<V>> nodes, Class<K> moduleDataClass) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "groupBy"));
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, node -> node.getParent(moduleDataClass));
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "groupBy"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<DataNode<V>> nodes, @NotNull Key<K> key) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "groupBy"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "groupBy"));
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, node -> {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$groupBy$3"));
            }
            return node.getDataNode(key);
        });
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "groupBy"));
        }
        return multiMap;
    }

    @NotNull
    public static <T> Collection<DataNode<T>> getChildren(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getChildren"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getChildren"));
        }
        ArrayList result = null;
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result == null) {
                result = ContainerUtilRt.newArrayList();
            }
            result.add(child);
        }
        List<DataNode<Object>> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getChildren"));
        }
        return list;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "find"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "find"));
        }
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key, BooleanFunction<DataNode<T>> predicate) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "find"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "find"));
        }
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey()) || !predicate.fun(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findParent"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findParent"));
        }
        return ExternalSystemApiUtil.findParent(node, key, null);
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key, @Nullable BooleanFunction<DataNode<T>> predicate) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findParent"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findParent"));
        }
        DataNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return key.equals(parent.getKey()) && (predicate == null || predicate.fun(parent)) ? parent : ExternalSystemApiUtil.findParent(parent, key, predicate);
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAll(@NotNull DataNode<?> parent, @NotNull Key<T> key) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAll"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAll"));
        }
        Collection<DataNode<T>> collection = ExternalSystemApiUtil.getChildren(parent, key);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAll"));
        }
        return collection;
    }

    public static void visit(@Nullable DataNode node, @NotNull Consumer<DataNode<?>> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "visit"));
        }
        if (node == null) {
            return;
        }
        Stack toProcess = ContainerUtil.newStack((Object[])new DataNode[]{node});
        while (!toProcess.isEmpty()) {
            DataNode node0 = (DataNode)toProcess.pop();
            consumer.consume((Object)node0);
            for (DataNode<?> child : node0.getChildren()) {
                toProcess.push(child);
            }
        }
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAllRecursively(@Nullable DataNode<?> node, @NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        if (node == null) {
            List<DataNode<T>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
            }
            return list;
        }
        Collection<DataNode<?>> nodes = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), node1 -> {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$findAllRecursively$4"));
            }
            return node1.getKey().equals(key);
        });
        SmartList smartList = new SmartList(nodes);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        return smartList;
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        Collection<DataNode<?>> collection = ExternalSystemApiUtil.findAllRecursively(nodes, null);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        return collection;
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@Nullable DataNode<?> node, @Nullable BooleanFunction<DataNode<?>> predicate) {
        if (node == null) {
            List<DataNode<?>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
            }
            return list;
        }
        Collection<DataNode<?>> collection = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        return collection;
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<DataNode<?>> nodes, @Nullable BooleanFunction<DataNode<?>> predicate) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        SmartList result = new SmartList();
        for (DataNode<?> node : nodes) {
            if (predicate != null && !predicate.fun(node)) continue;
            result.add(node);
        }
        for (DataNode<?> node : nodes) {
            result.addAll(ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findAllRecursively"));
        }
        return smartList;
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull DataNode<?> parentNode, @NotNull BooleanFunction<DataNode<?>> predicate) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findFirstRecursively"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findFirstRecursively"));
        }
        LinkedList queue = new LinkedList();
        queue.add(parentNode);
        return ExternalSystemApiUtil.findInQueue(queue, predicate);
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull Collection<DataNode<?>> nodes, @NotNull BooleanFunction<DataNode<?>> predicate) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findFirstRecursively"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findFirstRecursively"));
        }
        return ExternalSystemApiUtil.findInQueue(new LinkedList(nodes), predicate);
    }

    @Nullable
    private static DataNode<?> findInQueue(@NotNull Queue<DataNode<?>> queue, @NotNull BooleanFunction<DataNode<?>> predicate) {
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findInQueue"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "findInQueue"));
        }
        while (!queue.isEmpty()) {
            DataNode<?> node = queue.remove();
            if (predicate.fun(node)) {
                return node;
            }
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public static void commitChangedModels(boolean synchronous, Project project, List<Library.ModifiableModel> models) {
        final List changedModels = ContainerUtil.findAll(models, model -> model.isChanged());
        if (!changedModels.isEmpty()) {
            ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project){

                @Override
                public void execute() {
                    for (Library.ModifiableModel modifiableModel : changedModels) {
                        modifiableModel.commit();
                    }
                }
            });
        }
    }

    public static void disposeModels(@NotNull Collection<ModifiableRootModel> models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "disposeModels"));
        }
        for (ModifiableRootModel model : models) {
            if (model.isDisposed()) continue;
            model.dispose();
        }
    }

    public static void commitModels(boolean synchronous, Project project, List<ModifiableRootModel> models) {
        final ArrayList changedModels = ContainerUtilRt.newArrayList();
        for (ModifiableRootModel modifiableRootModel : models) {
            if (modifiableRootModel.isDisposed()) continue;
            if (modifiableRootModel.isChanged()) {
                changedModels.add(modifiableRootModel);
                continue;
            }
            modifiableRootModel.dispose();
        }
        if (!changedModels.isEmpty()) {
            ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project){

                @Override
                public void execute() {
                    for (ModifiableRootModel modifiableRootModel : changedModels) {
                        if (modifiableRootModel.isDisposed()) continue;
                        modifiableRootModel.commit();
                    }
                }
            });
        }
    }

    public static void executeProjectChangeAction(@NotNull DisposeAwareProjectChange task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "executeProjectChangeAction"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction(true, task);
    }

    public static void executeProjectChangeAction(boolean synchronous, @NotNull DisposeAwareProjectChange task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "executeProjectChangeAction"));
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ExternalSystemApiUtil.executeOnEdt(synchronous, () -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$executeProjectChangeAction$7"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$null$6"));
                }
                task.run();
            });
        });
    }

    public static void executeOnEdt(boolean synchronous, @NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "executeOnEdt"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            task.run();
            return;
        }
        if (synchronous) {
            app.invokeAndWait(task);
        } else {
            app.invokeLater(task);
        }
    }

    public static <T> T executeOnEdt(@NotNull Computable<T> task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "executeOnEdt"));
        }
        Application app = ApplicationManager.getApplication();
        Ref result = Ref.create();
        app.invokeAndWait(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$executeOnEdt$8"));
            }
            result.set(task.compute());
        });
        return (T)result.get();
    }

    public static <T> T doWriteAction(@NotNull Computable<T> task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "doWriteAction"));
        }
        return ExternalSystemApiUtil.executeOnEdt(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$doWriteAction$9"));
            }
            return ApplicationManager.getApplication().runWriteAction(task);
        });
    }

    public static void doWriteAction(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "doWriteAction"));
        }
        ExternalSystemApiUtil.executeOnEdt(true, () -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "lambda$doWriteAction$10"));
            }
            ApplicationManager.getApplication().runWriteAction(task);
        });
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || application.isDispatchThread()) {
            runnable.run();
        } else {
            TRANSFER_TO_EDT_QUEUE.offer((Object)runnable);
        }
    }

    public static void addBundle(@NotNull PathsList classPath, @NotNull String bundlePath, @NotNull Class<?> contextClass) {
        String root;
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "addBundle"));
        }
        if (bundlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundlePath", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "addBundle"));
        }
        if (contextClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextClass", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "addBundle"));
        }
        String pathToUse = bundlePath.replace('.', '/');
        if (!pathToUse.endsWith(".properties")) {
            pathToUse = pathToUse + ".properties";
        }
        if (!pathToUse.startsWith(PATH_SEPARATOR)) {
            pathToUse = '/' + pathToUse;
        }
        if ((root = PathManager.getResourceRoot(contextClass, (String)pathToUse)) != null) {
            classPath.add(root);
        }
    }

    @Nullable
    public static String normalizePath(@Nullable String s) {
        return StringUtil.isEmpty((String)s) ? null : s.replace('\\', '/');
    }

    public static boolean isOneToOneMapping(@NotNull Project ideProject, @NotNull ProjectData projectData) {
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isOneToOneMapping"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isOneToOneMapping"));
        }
        String linkedExternalProjectPath = null;
        for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId externalSystemId = manager.getSystemId();
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings(ideProject, externalSystemId);
            Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
            int linkedProjectsNumber = projectsSettings.size();
            if (linkedProjectsNumber > 1) {
                return false;
            }
            if (linkedProjectsNumber != 1) continue;
            if (linkedExternalProjectPath == null) {
                linkedExternalProjectPath = ((ExternalProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath();
                continue;
            }
            return false;
        }
        if (linkedExternalProjectPath != null && !linkedExternalProjectPath.equals(projectData.getLinkedExternalProjectPath())) {
            return false;
        }
        for (Module module : ModuleManager.getInstance(ideProject).getModules()) {
            if (ExternalSystemApiUtil.isExternalSystemAwareModule(projectData.getOwner(), module)) continue;
            return false;
        }
        return true;
    }

    public static void storeLastUsedExternalProjectPath(@Nullable String path2, @NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "storeLastUsedExternalProjectPath"));
        }
        if (path2 != null) {
            PropertiesComponent.getInstance().setValue(LAST_USED_PROJECT_PATH_PREFIX + externalSystemId.getReadableName(), path2);
        }
    }

    @NotNull
    public static String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        File targetProjectDir;
        if (targetProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getProjectRepresentationName"));
        }
        if (rootProjectPath == null) {
            File rootProjectDir = new File(targetProjectPath);
            if (rootProjectDir.isFile()) {
                rootProjectDir = rootProjectDir.getParentFile();
            }
            String string = rootProjectDir.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getProjectRepresentationName"));
            }
            return string;
        }
        File rootProjectDir = new File(rootProjectPath);
        if (rootProjectDir.isFile()) {
            rootProjectDir = rootProjectDir.getParentFile();
        }
        if ((targetProjectDir = new File(targetProjectPath)).isFile()) {
            targetProjectDir = targetProjectDir.getParentFile();
        }
        StringBuilder buffer = new StringBuilder();
        for (File f = targetProjectDir; f != null && !FileUtil.filesEqual((File)f, (File)rootProjectDir); f = f.getParentFile()) {
            buffer.insert(0, f.getName()).insert(0, ":");
        }
        buffer.insert(0, rootProjectDir.getName());
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getProjectRepresentationName"));
        }
        return string;
    }

    @Nullable
    public static String getRootProjectPath(@NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getRootProjectPath"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getRootProjectPath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getRootProjectPath"));
        }
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            return null;
        }
        if (manager instanceof ExternalSystemAutoImportAware) {
            return ((ExternalSystemAutoImportAware)((Object)manager)).getAffectedExternalProjectPath(externalProjectPath, project);
        }
        return null;
    }

    @NotNull
    public static String buildErrorMessage(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "buildErrorMessage"));
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String string = ExternalSystemApiUtil.stacktraceAsString(unwrapped);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "buildErrorMessage"));
            }
            return string;
        }
        String reason = unwrapped.getLocalizedMessage();
        if (!StringUtil.isEmpty((String)reason)) {
            String string = reason;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "buildErrorMessage"));
            }
            return string;
        }
        if (unwrapped.getClass() == ExternalSystemException.class) {
            String string = String.format("exception during working with external system: %s", ((ExternalSystemException)unwrapped).getOriginalReason());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "buildErrorMessage"));
            }
            return string;
        }
        String string = ExternalSystemApiUtil.stacktraceAsString(unwrapped);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "buildErrorMessage"));
        }
        return string;
    }

    private static String stacktraceAsString(Throwable unwrapped) {
        StringWriter writer = new StringWriter();
        unwrapped.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @NotNull
    public static AbstractExternalSystemSettings getSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getSettings"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getSettings"));
        }
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        if (abstractExternalSystemSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getSettings"));
        }
        return abstractExternalSystemSettings;
    }

    public static <S extends AbstractExternalSystemLocalSettings> S getLocalSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLocalSettings"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getLocalSettings"));
        }
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve local external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project));
    }

    public static <S extends ExternalSystemExecutionSettings> S getExecutionSettings(@NotNull Project project, @NotNull String linkedProjectPath, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getExecutionSettings"));
        }
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getExecutionSettings"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "getExecutionSettings"));
        }
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system execution settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((ExternalSystemExecutionSettings)manager.getExecutionSettingsProvider().fun((Object)Pair.create((Object)project, (Object)linkedProjectPath)));
    }

    public static boolean isInProcessMode(ProjectSystemId externalSystemId) {
        return Registry.is((String)(externalSystemId.getId() + ".system.in.process"), (boolean)false);
    }

    @NotNull
    public static <T extends ParametersEnhancer> T reloadIfNecessary(final @NotNull Class<T> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "reloadIfNecessary"));
        }
        ParametersEnhancer instance = (ParametersEnhancer)clazz.newInstance();
        ArrayList urls = ContainerUtilRt.newArrayList();
        instance.enhanceLocalProcessing(urls);
        if (urls.isEmpty()) {
            ParametersEnhancer parametersEnhancer = instance;
            if (parametersEnhancer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "reloadIfNecessary"));
            }
            return (T)parametersEnhancer;
        }
        final ClassLoader baseLoader = clazz.getClassLoader();
        Method method = baseLoader.getClass().getMethod("getUrls", new Class[0]);
        if (method != null) {
            urls.addAll((Collection)method.invoke((Object)baseLoader, new Object[0]));
        }
        UrlClassLoader loader = new UrlClassLoader(UrlClassLoader.build().urls((List)urls).parent(baseLoader.getParent())){

            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.equals(clazz.getName())) {
                    return super.loadClass(name, resolve);
                }
                try {
                    return baseLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return super.loadClass(name, resolve);
                }
            }
        };
        ParametersEnhancer parametersEnhancer = (ParametersEnhancer)loader.loadClass(clazz.getName()).newInstance();
        if (parametersEnhancer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "reloadIfNecessary"));
        }
        return (T)parametersEnhancer;
    }

    public static ProjectModelExternalSource toExternalSource(@NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "toExternalSource"));
        }
        return ExternalProjectSystemRegistry.getInstance().getSourceById(systemId.getId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull ProjectSystemId systemId, @Nullable Module module) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isExternalSystemAwareModule"));
        }
        return module != null && !module.isDisposed() && systemId.getId().equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull String systemId, @Nullable Module module) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "isExternalSystemAwareModule"));
        }
        return module != null && !module.isDisposed() && systemId.equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalRootProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getRootProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectId(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectId() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectGroup(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleGroup() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectVersion(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleVersion() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalModuleType(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleType() : null;
    }

    public static void subscribe(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalSystemSettingsListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "subscribe"));
        }
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "subscribe"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil", "subscribe"));
        }
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener);
    }
}

