/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationFactory;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LayoutMorpher;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLayoutAction
extends AbstractGraphToggleAction {
    protected AbstractLayoutAction() {
        super((Icon)null);
    }

    protected AbstractLayoutAction(Graph2D graph) {
        super(graph, null);
    }

    @Override
    protected boolean isSelected(Graph2D graph, Project project, AnActionEvent event) {
        return GraphSettingsProvider.getInstance(project).getSettings(graph).getCurrentLayouter() == this.getLayouter(graph, project);
    }

    @Override
    protected void setSelected(Graph2D graph, boolean state, Project project, AnActionEvent e) {
        Graph2DView view = AbstractGraphAction.getGraph2DView(graph);
        Layouter layouter = this.getLayouter(graph, project);
        GraphSettingsProvider.getInstance(project).getSettings(graph).setCurrentLayouter(layouter);
        AbstractLayoutAction.doLayout(view, layouter, project);
    }

    @Override
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction", "getText"));
        }
        return this.getLayoutName();
    }

    public static void doLayout(Graph2DView view, Layouter layouter, Project project) {
        if (GraphSettingsProvider.getInstance(project).getSettings(view.getGraph2D()).isFitContentAfterLayout()) {
            GraphManager.getGraphManager().createBufferedLayouter(layouter).doLayout(view.getGraph2D());
            view.fitContent();
        } else {
            GraphLayout layout = GraphManager.getGraphManager().createBufferedLayouter(layouter).calcLayout(view.getGraph2D());
            LayoutMorpher morpher = GraphManager.getGraphManager().createLayoutMorpher(view, layout);
            morpher.setPreferredDuration(800L);
            morpher.setKeepZoomFactor(true);
            AnimationPlayer player = GraphManager.getGraphManager().createAnimationPlayer();
            player.addAnimationListener(view);
            player.setFps(1200);
            player.animate(AnimationFactory.Statics.createEasedAnimation(morpher));
            GraphViewUtil.updateWorldRect(view);
        }
        view.getGraph2D().updateViews();
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Graph2D graph = this.getGraph(e);
        Project project = AbstractLayoutAction.getEventProject(e);
        presentation.setEnabled(project != null && graph != null && graph.getNodeArray().length > 0 && this.getLayouter(graph, project).canLayout(graph));
    }

    protected abstract Layouter getLayouter(Graph var1, Project var2);

    protected abstract String getLayoutName();
}

