/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class BasicGraphComponent<N, E>
implements Disposable {
    private final JComponent myComponent;
    private final GraphBuilder<N, E> myBuilder;

    public BasicGraphComponent(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/graph/builder/components/BasicGraphComponent", "<init>"));
        }
        this.myBuilder = builder;
        this.myComponent = new JPanel(new BorderLayout());
        DefaultActionGroup actions = this.createToolbar(builder);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", actions, true);
        this.myComponent.add((Component)actionToolbar.getComponent(), "North");
        this.myComponent.add(builder.getView().getComponent(), "Center");
        Disposer.register((Disposable)this, builder);
        builder.initialize();
    }

    protected DefaultActionGroup createToolbar(GraphBuilder<N, E> builder) {
        return GraphViewUtil.getBasicToolbar(builder);
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/components/BasicGraphComponent", "getComponent"));
        }
        return jComponent;
    }

    @NotNull
    public GraphBuilder<N, E> getBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myBuilder;
        if (graphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/components/BasicGraphComponent", "getBuilder"));
        }
        return graphBuilder;
    }
}

