/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(@NotNull String jdkName, @NotNull String home) {
        if (jdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkName", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "createJdk"));
        }
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "createJdk"));
        }
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message("sdk.java.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "getPresentableName"));
        }
        return string;
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "createAdditionalDataConfigurable"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "createAdditionalDataConfigurable"));
        }
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "saveAdditionalData"));
        }
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "getBinPath"));
        }
        return new File(sdk.getHomePath(), "bin").getPath();
    }

    @Override
    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "getToolsPath"));
        }
        return new File(sdk.getHomePath(), "lib/tools.jar").getPath();
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SimpleJavaSdkType", "getVMExecutablePath"));
        }
        return new File(sdk.getHomePath(), "bin/java").getPath();
    }

    @Override
    public String suggestHomePath() {
        return null;
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return JdkUtil.checkForJdk(path2);
    }

    @Override
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return currentSdkName;
    }

    @Override
    public final String getVersionString(String sdkHome) {
        return SdkVersionUtil.detectJdkVersion(sdkHome);
    }
}

