/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FilterDescendantVirtualFileConvertible<T>
extends AbstractFilterChildren<T> {
    @NotNull
    private final Comparator<T> myComparator;
    @NotNull
    private final Function<T, VirtualFile> myConvertor;

    public FilterDescendantVirtualFileConvertible(@NotNull Function<T, VirtualFile> convertor, @NotNull Comparator<VirtualFile> comparator) {
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/vcs/FilterDescendantVirtualFileConvertible", "<init>"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/openapi/vcs/FilterDescendantVirtualFileConvertible", "<init>"));
        }
        this.myConvertor = convertor;
        this.myComparator = Comparator.comparing(this.myConvertor, comparator);
    }

    @Override
    protected void sortAscending(@NotNull List<T> ts) {
        if (ts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ts", "com/intellij/openapi/vcs/FilterDescendantVirtualFileConvertible", "sortAscending"));
        }
        Collections.sort(ts, this.myComparator);
    }

    @Override
    protected boolean isAncestor(T parent, T child) {
        return VfsUtil.isAncestor(this.myConvertor.apply(parent), this.myConvertor.apply(child), false);
    }
}

