/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.checkin.HackSearch;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StepIntersection<Data, Area> {
    private final Convertor<Data, TextRange> myDataConvertor;
    private final Convertor<Area, TextRange> myAreasConvertor;
    private TextRange myDataRange;
    private TextRange myAreaRange;
    private Data myCurData;
    private Iterator<Data> myDataIterator;
    private int myAreaIndex;
    private Area myCurArea;
    private final List<Area> myAreas;
    private final HackSearch<Data, Area, TextRange> myHackSearch;

    public StepIntersection(Convertor<Data, TextRange> dataConvertor, Convertor<Area, TextRange> areasConvertor, List<Area> areas) {
        this.myAreas = areas;
        this.myAreaIndex = 0;
        this.myDataConvertor = dataConvertor;
        this.myAreasConvertor = areasConvertor;
        this.myHackSearch = new HackSearch<Data, Area, TextRange>(this.myDataConvertor, this.myAreasConvertor, (o1, o2) -> o1.intersects(o2) ? 0 : (o1.getStartOffset() < o2.getStartOffset() ? -1 : 1));
    }

    public List<Data> process(Iterable<Data> data) {
        ArrayList result = new ArrayList();
        this.process(data, (data1, area) -> result.add(data1));
        return result;
    }

    public void process(Iterable<Data> data, PairConsumer<Data, Area> consumer) {
        this.myDataIterator = data.iterator();
        if (!this.myDataIterator.hasNext() || this.noMoreAreas()) {
            return;
        }
        this.dataStep();
        this.initArea();
        while (!this.noMoreAreas()) {
            boolean intersects = this.myAreaRange.intersects(this.myDataRange);
            if (intersects) {
                consumer.consume(this.myCurData, this.myCurArea);
            }
            if (!this.myDataIterator.hasNext() && this.noMoreAreas()) break;
            if (!this.myDataIterator.hasNext()) {
                this.areaStep();
                continue;
            }
            if (this.noMoreAreas()) {
                this.dataStep();
                continue;
            }
            if (this.myDataRange.getEndOffset() < this.myAreaRange.getEndOffset()) {
                this.dataStep();
                continue;
            }
            this.areaStep();
        }
    }

    private boolean noMoreAreas() {
        return this.myAreaIndex >= this.myAreas.size();
    }

    private void initArea() {
        this.myAreaIndex = 0;
        this.myCurArea = this.myAreas.get(this.myAreaIndex);
        this.myAreaRange = (TextRange)this.myAreasConvertor.convert(this.myCurArea);
    }

    private void areaStep() {
        int idx = this.myHackSearch.search(this.myAreas.subList(this.myAreaIndex + 1, this.myAreas.size()), this.myCurData);
        this.myAreaIndex = this.myAreaIndex + 1 + idx;
        if (this.myAreaIndex >= this.myAreas.size()) {
            return;
        }
        this.myCurArea = this.myAreas.get(this.myAreaIndex);
        this.myAreaRange = (TextRange)this.myAreasConvertor.convert(this.myCurArea);
    }

    private void dataStep() {
        this.myCurData = this.myDataIterator.next();
        this.myDataRange = (TextRange)this.myDataConvertor.convert(this.myCurData);
    }
}

