/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdInvertibleArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class StdArrangementTokens {
    private static final Map<String, StdArrangementSettingsToken> TOKENS_BY_ID = ContainerUtilRt.newHashMap();
    private static final NotNullLazyValue<Integer> NESTED_CLASSES_INITIALIZER = new NotNullLazyValue<Integer>(){

        @NotNull
        protected Integer compute() {
            int dummy = 0;
            for (Class<?> clazz : StdArrangementTokens.class.getClasses()) {
                try {
                    dummy += clazz.getDeclaredFields()[0].get(null).hashCode();
                }
                catch (IllegalAccessException e) {
                    assert (false);
                }
            }
            Integer n = dummy;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens$1", "compute"));
            }
            return n;
        }
    };

    private StdArrangementTokens() {
    }

    @Nullable
    public static ArrangementSettingsToken byId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "byId"));
        }
        NESTED_CLASSES_INITIALIZER.getValue();
        return TOKENS_BY_ID.get(id);
    }

    private static NotNullLazyValue<Set<ArrangementSettingsToken>> collectFields(final @NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "collectFields"));
        }
        return new NotNullLazyValue<Set<ArrangementSettingsToken>>(){

            @NotNull
            protected Set<ArrangementSettingsToken> compute() {
                HashSet result = ContainerUtilRt.newHashSet();
                for (Field field : clazz.getFields()) {
                    if (!ArrangementSettingsToken.class.isAssignableFrom(field.getType())) continue;
                    try {
                        result.add((ArrangementSettingsToken)field.get(null));
                    }
                    catch (IllegalAccessException e) {
                        assert (false) : e;
                    }
                }
                HashSet hashSet = result;
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens$2", "compute"));
                }
                return hashSet;
            }
        };
    }

    private static StdArrangementSettingsToken invertible(@NotNull String id, @NotNull StdArrangementTokenType type) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "invertible"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "invertible"));
        }
        StdInvertibleArrangementSettingsToken result = StdInvertibleArrangementSettingsToken.invertibleTokenById(id, type);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    private static StdArrangementSettingsToken token(@NotNull String id, @NotNull StdArrangementTokenType type) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "token"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "token"));
        }
        StdArrangementSettingsToken result = StdArrangementSettingsToken.tokenById(id, type);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    private static StdArrangementSettingsToken compositeToken(@NotNull String id, @NotNull StdArrangementTokenType type, ArrangementSettingsToken ... alternativeTokens) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "compositeToken"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "compositeToken"));
        }
        if (alternativeTokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alternativeTokens", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "compositeToken"));
        }
        CompositeArrangementToken result = CompositeArrangementToken.create(id, type, alternativeTokens);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    private static StdArrangementSettingsToken token(@NotNull String id, @NotNull @PropertyKey(resourceBundle="messages.ApplicationBundle") String key, @NotNull StdArrangementTokenType type) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "token"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "token"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens", "token"));
        }
        StdArrangementSettingsToken result = StdArrangementSettingsToken.tokenByBundle(id, key, type);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    static /* synthetic */ StdArrangementSettingsToken access$000(String x0, String x1, StdArrangementTokenType x2) {
        return StdArrangementTokens.token(x0, x1, x2);
    }

    static /* synthetic */ StdArrangementSettingsToken access$100(String x0, StdArrangementTokenType x1) {
        return StdArrangementTokens.token(x0, x1);
    }

    static /* synthetic */ StdArrangementSettingsToken access$200(String x0, StdArrangementTokenType x1) {
        return StdArrangementTokens.invertible(x0, x1);
    }

    static /* synthetic */ NotNullLazyValue access$300(Class x0) {
        return StdArrangementTokens.collectFields(x0);
    }

    static /* synthetic */ StdArrangementSettingsToken access$400(String x0, StdArrangementTokenType x1, ArrangementSettingsToken[] x2) {
        return StdArrangementTokens.compositeToken(x0, x1, x2);
    }

    public static class Order {
        @NotNull
        public static final ArrangementSettingsToken KEEP = StdArrangementTokens.access$000("KEEP", "arrangement.settings.order.type.keep", StdArrangementTokenType.ORDER);
        @NotNull
        public static final ArrangementSettingsToken BY_NAME = StdArrangementTokens.access$000("BY_NAME", "arrangement.settings.order.type.by.name", StdArrangementTokenType.ORDER);
        @NotNull
        public static final ArrangementSettingsToken DEPTH_FIRST = StdArrangementTokens.access$000("DEPTH_FIRST", "arrangement.settings.order.type.depth.first", StdArrangementTokenType.ORDER);
        @NotNull
        public static final ArrangementSettingsToken BREADTH_FIRST = StdArrangementTokens.access$000("BREADTH_FIRST", "arrangement.settings.order.type.breadth.first", StdArrangementTokenType.ORDER);

        private Order() {
        }
    }

    public static class Grouping {
        @NotNull
        public static final ArrangementSettingsToken GETTERS_AND_SETTERS = StdArrangementTokens.access$000("GETTERS_AND_SETTERS", "arrangement.settings.groups.getters.and.setters.together", StdArrangementTokenType.GROUPING);
        @NotNull
        public static final ArrangementSettingsToken OVERRIDDEN_METHODS = StdArrangementTokens.access$000("OVERRIDDEN_METHODS", "arrangement.settings.groups.overridden.methods", StdArrangementTokenType.GROUPING);
        @NotNull
        public static final ArrangementSettingsToken DEPENDENT_METHODS = StdArrangementTokens.access$000("DEPENDENT_METHODS", "arrangement.settings.groups.dependent.methods", StdArrangementTokenType.GROUPING);
        @NotNull
        public static final ArrangementSettingsToken GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER = StdArrangementTokens.access$000("GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER", "arrangement.settings.groups.property.field", StdArrangementTokenType.GROUPING);

        private Grouping() {
        }
    }

    public static class Modifier {
        @NotNull
        public static final ArrangementSettingsToken PUBLIC = StdArrangementTokens.access$200("PUBLIC", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken PROTECTED = StdArrangementTokens.access$200("PROTECTED", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken PRIVATE = StdArrangementTokens.access$200("PRIVATE", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken PACKAGE_PRIVATE = StdArrangementTokens.access$200("PACKAGE_PRIVATE", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken STATIC = StdArrangementTokens.access$200("STATIC", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken FINAL = StdArrangementTokens.access$200("FINAL", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken READONLY = StdArrangementTokens.access$200("READONLY", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken TRANSIENT = StdArrangementTokens.access$200("TRANSIENT", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken VOLATILE = StdArrangementTokens.access$200("VOLATILE", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken SYNCHRONIZED = StdArrangementTokens.access$200("SYNCHRONIZED", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken ABSTRACT = StdArrangementTokens.access$200("ABSTRACT", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken OVERRIDE = StdArrangementTokens.access$200("OVERRIDE", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken GETTER = StdArrangementTokens.access$400("GETTER", StdArrangementTokenType.MODIFIER, new ArrangementSettingsToken[]{EntryType.METHOD, PUBLIC});
        @NotNull
        public static final ArrangementSettingsToken SETTER = StdArrangementTokens.access$400("SETTER", StdArrangementTokenType.MODIFIER, new ArrangementSettingsToken[]{EntryType.METHOD, PUBLIC});
        @NotNull
        public static final ArrangementSettingsToken OVERRIDDEN = StdArrangementTokens.access$400("OVERRIDDEN", StdArrangementTokenType.MODIFIER, new ArrangementSettingsToken[]{EntryType.METHOD, PUBLIC, PROTECTED});
        private static final NotNullLazyValue<Set<ArrangementSettingsToken>> TOKENS = StdArrangementTokens.access$300(Modifier.class);
        public static final Set<ArrangementSettingsToken> MODIFIER_AS_TYPE = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{GETTER, SETTER, OVERRIDDEN});

        private Modifier() {
        }

        @NotNull
        public static Set<ArrangementSettingsToken> values() {
            Set set = (Set)TOKENS.getValue();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens$Modifier", "values"));
            }
            return set;
        }
    }

    public static class EntryType {
        @NotNull
        public static final ArrangementSettingsToken CLASS = StdArrangementTokens.access$200("CLASS", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken ANONYMOUS_CLASS = StdArrangementTokens.access$200("ANONYMOUS_CLASS", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken FIELD = StdArrangementTokens.access$200("FIELD", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken CONSTRUCTOR = StdArrangementTokens.access$200("CONSTRUCTOR", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken METHOD = StdArrangementTokens.access$200("METHOD", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken ENUM = StdArrangementTokens.access$200("ENUM", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken INTERFACE = StdArrangementTokens.access$200("INTERFACE", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken CONST = StdArrangementTokens.access$200("CONST", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken VAR = StdArrangementTokens.access$200("VAR", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken PROPERTY = StdArrangementTokens.access$200("PROPERTY", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken EVENT_HANDLER = StdArrangementTokens.access$200("EVENT_HANDLER", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken STATIC_INIT = StdArrangementTokens.access$200("STATIC_INIT", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken INIT_BLOCK = StdArrangementTokens.access$200("INITIALIZER_BLOCK", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken NAMESPACE = StdArrangementTokens.access$200("NAMESPACE", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken TRAIT = StdArrangementTokens.access$200("TRAIT", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken XML_TAG = StdArrangementTokens.access$000("XML_TAG", "arrangement.settings.text.entry.type.xml.tag", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final StdArrangementSettingsToken XML_ATTRIBUTE = StdArrangementTokens.access$000("XML_ATTRIBUTE", "arrangement.settings.text.entry.type.xml.attribute", StdArrangementTokenType.ENTRY_TYPE);
        private static final NotNullLazyValue<Set<ArrangementSettingsToken>> TOKENS = StdArrangementTokens.access$300(EntryType.class);

        private EntryType() {
        }

        @NotNull
        public static Set<ArrangementSettingsToken> values() {
            Set set = (Set)TOKENS.getValue();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens$EntryType", "values"));
            }
            return set;
        }
    }

    public static class Regexp {
        @NotNull
        public static final StdArrangementSettingsToken NAME = StdArrangementTokens.access$000("NAME", "arrangement.settings.text.general.name", StdArrangementTokenType.REG_EXP);
        @NotNull
        public static final StdArrangementSettingsToken XML_NAMESPACE = StdArrangementTokens.access$000("XML_NAMESPACE", "arrangement.settings.text.general.xml.namespace", StdArrangementTokenType.REG_EXP);
        @NotNull
        public static final StdArrangementSettingsToken TEXT = StdArrangementTokens.access$000("TEXT", "arrangement.settings.text.general.text", StdArrangementTokenType.REG_EXP);

        private Regexp() {
        }
    }

    public static class Section {
        @NotNull
        public static final ArrangementSettingsToken START_SECTION = StdArrangementTokens.access$100("SECTION_START", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken END_SECTION = StdArrangementTokens.access$100("SECTION_END", StdArrangementTokenType.ENTRY_TYPE);

        private Section() {
        }
    }

    public static class General {
        @NotNull
        public static final ArrangementSettingsToken TYPE = StdArrangementTokens.access$000("TYPE", "arrangement.settings.text.general.type", StdArrangementTokenType.GENERAL);
        @NotNull
        public static final ArrangementSettingsToken MODIFIER = StdArrangementTokens.access$000("MODIFIER", "arrangement.settings.text.general.modifier", StdArrangementTokenType.GENERAL);
        @NotNull
        public static final ArrangementSettingsToken ORDER = StdArrangementTokens.access$000("ORDER", "arrangement.settings.text.general.order", StdArrangementTokenType.GENERAL);
        @NotNull
        public static final ArrangementSettingsToken ALIAS = StdArrangementTokens.access$000("ALIAS", "arrangement.settings.text.general.sequence", StdArrangementTokenType.GENERAL);

        private General() {
        }
    }
}

