/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class OverridingMethodsSearch
extends ExtensibleQueryFactory<PsiMethod, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.overridingMethodsSearch");
    public static final OverridingMethodsSearch INSTANCE = new OverridingMethodsSearch();

    private OverridingMethodsSearch() {
    }

    public static Query<PsiMethod> search(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean checkDeep) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/OverridingMethodsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/OverridingMethodsSearch", "search"));
        }
        if (((Boolean)ReadAction.compute(() -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/OverridingMethodsSearch", "lambda$search$0"));
            }
            return !OverridingMethodsSearch.canBeOverridden(method);
        })).booleanValue()) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(method, scope, checkDeep));
    }

    private static boolean canBeOverridden(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/OverridingMethodsSearch", "canBeOverridden"));
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method, boolean checkDeep) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/OverridingMethodsSearch", "search"));
        }
        Query<PsiMethod> query = OverridingMethodsSearch.search(method, (SearchScope)ReadAction.compute(method::getUseScope), checkDeep);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/OverridingMethodsSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/OverridingMethodsSearch", "search"));
        }
        Query<PsiMethod> query = OverridingMethodsSearch.search(method, true);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/OverridingMethodsSearch", "search"));
        }
        return query;
    }

    public static class SearchParameters {
        @NotNull
        private final PsiMethod myMethod;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean checkDeep) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters", "<init>"));
            }
            this.myMethod = method;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        @NotNull
        public PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters", "getMethod"));
            }
            return psiMethod;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }
    }
}

