/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredListCellRenderer<T>
extends SimpleColoredComponent
implements ListCellRenderer<T> {
    private final ListCellRenderer myDefaultGtkRenderer = UIUtil.isUnderGTKLookAndFeel() ? new JComboBox().getRenderer() : null;
    protected boolean mySelected;
    protected Color myForeground;
    protected Color mySelectionForeground;
    @Nullable
    private final JComboBox myComboBox;

    public ColoredListCellRenderer() {
        this(null);
    }

    public ColoredListCellRenderer(@Nullable JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.setFocusBorderAroundIcon(true);
        this.getIpad().left = UIUtil.getListCellHPadding();
        this.getIpad().right = UIUtil.getListCellHPadding();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
        Component component;
        this.clear();
        if (this.myComboBox != null) {
            this.setEnabled(this.myComboBox.isEnabled());
        }
        this.setFont(list.getFont());
        this.mySelected = selected;
        this.myForeground = this.isEnabled() ? list.getForeground() : UIManager.getColor("Label.disabledForeground");
        this.mySelectionForeground = list.getSelectionForeground();
        if (UIUtil.isWinLafOnVista()) {
            if (index == -1) {
                this.setOpaque(false);
                this.mySelected = false;
            } else {
                this.setOpaque(true);
                this.setBackground(selected ? list.getSelectionBackground() : null);
            }
        } else if (UIUtil.isUnderWin10LookAndFeel()) {
            this.setBackground(selected ? list.getSelectionBackground() : list.getBackground());
        } else {
            this.setBackground(selected ? list.getSelectionBackground() : null);
        }
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, value, index, selected, hasFocus);
        if (this.myDefaultGtkRenderer != null && list.getModel() instanceof ComboBoxModel && (component = this.myDefaultGtkRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus)) instanceof JLabel) {
            return this.formatToLabel((JLabel)component);
        }
        return this;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/ui/ColoredListCellRenderer", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/ColoredListCellRenderer", "append"));
        }
        if (this.mySelected) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), this.mySelectionForeground), isMainText);
        } else if (attributes.getFgColor() == null) {
            super.append(fragment, attributes.derive(-1, this.myForeground, null, null), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    void revalidateAndRepaint() {
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Font oldFont = this.getFont();
        if (oldFont == null) {
            this.setFont(UIUtil.getListFont());
        }
        Dimension result = super.getPreferredSize();
        if (oldFont == null) {
            this.setFont(null);
        }
        Dimension dimension = result;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ColoredListCellRenderer", "getPreferredSize"));
        }
        return dimension;
    }

    protected abstract void customizeCellRenderer(@NotNull JList<? extends T> var1, T var2, int var3, boolean var4, boolean var5);

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }
}

