/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;

public class QueueProcessor<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.concurrency.QueueProcessor");
    private final PairConsumer<T, Runnable> myProcessor;
    private final Deque<T> myQueue;
    private boolean isProcessing;
    private boolean myStarted;
    private final ThreadToUse myThreadToUse;
    private final Condition<?> myDeathCondition;
    private final Map<Object, ModalityState> myModalityState;

    public QueueProcessor(@NotNull Consumer<T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        this(processor, Conditions.alwaysFalse());
    }

    public QueueProcessor(@NotNull Consumer<T> processor, @NotNull Condition<?> deathCondition) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        if (deathCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deathCondition", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        this(processor, deathCondition, true);
    }

    public QueueProcessor(@NotNull Consumer<T> processor, @NotNull Condition<?> deathCondition, boolean autostart) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        if (deathCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deathCondition", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        this(QueueProcessor.wrappingProcessor(processor), autostart, ThreadToUse.POOLED, deathCondition);
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor() {
        QueueProcessor<Runnable> queueProcessor = new QueueProcessor<Runnable>(new RunnableConsumer());
        if (queueProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/QueueProcessor", "createRunnableQueueProcessor"));
        }
        return queueProcessor;
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor(ThreadToUse threadToUse) {
        QueueProcessor<Runnable> queueProcessor = new QueueProcessor<Runnable>(QueueProcessor.wrappingProcessor(new RunnableConsumer()), true, threadToUse, Conditions.FALSE);
        if (queueProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/QueueProcessor", "createRunnableQueueProcessor"));
        }
        return queueProcessor;
    }

    @NotNull
    private static <T> PairConsumer<T, Runnable> wrappingProcessor(@NotNull Consumer<T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "wrappingProcessor"));
        }
        PairConsumer pairConsumer = (item, runnable) -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "lambda$wrappingProcessor$1"));
            }
            QueueProcessor.runSafely(() -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "lambda$null$0"));
                }
                processor.consume(item);
            });
            runnable.run();
        };
        if (pairConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/QueueProcessor", "wrappingProcessor"));
        }
        return pairConsumer;
    }

    public QueueProcessor(@NotNull PairConsumer<T, Runnable> processor, boolean autostart, @NotNull ThreadToUse threadToUse, @NotNull Condition<?> deathCondition) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        if (threadToUse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadToUse", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        if (deathCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deathCondition", "com/intellij/util/concurrency/QueueProcessor", "<init>"));
        }
        this.myQueue = new ArrayDeque<T>();
        this.myModalityState = ContainerUtil.newIdentityTroveMap();
        this.myProcessor = processor;
        this.myStarted = autostart;
        this.myThreadToUse = threadToUse;
        this.myDeathCondition = deathCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            if (this.myStarted) {
                return;
            }
            this.myStarted = true;
            if (!this.myQueue.isEmpty()) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcessing(boolean continueProcessing) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.isProcessing = false;
            if (this.myQueue.isEmpty()) {
                this.myQueue.notifyAll();
            } else if (continueProcessing) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull T t, ModalityState state) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/concurrency/QueueProcessor", "add"));
        }
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myModalityState.put(t, state);
        }
        this.doAdd(t, false);
    }

    public void add(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/concurrency/QueueProcessor", "add"));
        }
        this.doAdd(element, false);
    }

    public void addFirst(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/concurrency/QueueProcessor", "addFirst"));
        }
        this.doAdd(element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(@NotNull T element, boolean atHead) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/concurrency/QueueProcessor", "doAdd"));
        }
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            if (atHead) {
                this.myQueue.addFirst(element);
            } else {
                this.myQueue.add(element);
            }
            this.startProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            while (this.isProcessing) {
                try {
                    this.myQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitFor(long timeoutMS) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            long start = System.currentTimeMillis();
            while (this.isProcessing) {
                long rest = timeoutMS - (System.currentTimeMillis() - start);
                if (rest <= 0L) {
                    return !this.isProcessing;
                }
                try {
                    this.myQueue.wait(rest);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private boolean startProcessing() {
        LOG.assertTrue(Thread.holdsLock(this.myQueue));
        if (this.isProcessing || !this.myStarted) {
            return false;
        }
        this.isProcessing = true;
        T item = this.myQueue.removeFirst();
        Runnable runnable = () -> {
            if (this.myDeathCondition.value(null)) {
                this.finishProcessing(false);
                return;
            }
            QueueProcessor.runSafely(() -> this.myProcessor.consume(item, () -> this.finishProcessing(true)));
        };
        Application application = ApplicationManager.getApplication();
        if (this.myThreadToUse == ThreadToUse.AWT) {
            ModalityState state = this.myModalityState.remove(item);
            if (state != null) {
                application.invokeLater(runnable, state);
            } else {
                application.invokeLater(runnable);
            }
        } else {
            application.executeOnPooledThread(runnable);
        }
        return true;
    }

    public static void runSafely(@Debugger.Insert(group="com.intellij.util.Alarm._addRequest") @NotNull Runnable run) {
        if (run == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "run", "com/intellij/util/concurrency/QueueProcessor", "runSafely"));
        }
        try {
            run.run();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                LOG.error(e);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.isEmpty() && !this.isProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissLastTasks(int remaining) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            while (this.myQueue.size() > remaining) {
                this.myQueue.pollLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingItemsToProcess() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return !this.myQueue.isEmpty();
        }
    }

    public static final class RunnableConsumer
    implements Consumer<Runnable> {
        public void consume(Runnable runnable) {
            runnable.run();
        }
    }

    public static enum ThreadToUse {
        AWT,
        POOLED;

    }
}

