/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CachedLocalModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringCachingProcessor;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.PsiElementPointer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleSpringModel
extends CachedLocalModel {
    private final SpringCachingProcessor<SpringModelSearchParameters.BeanClass> myBeanTypeCachingProcessor = new LocalBeansCachingProcessor<SpringModelSearchParameters.BeanClass>(){

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanClass parameters, Processor<SpringBeanPointer> collectProcessor) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$1", "doProcessBeans"));
            }
            AbstractSimpleSpringModel.this.processLocalBeans(parameters, (Processor<SpringBeanPointer>)collectProcessor);
        }
    };
    private final SpringCachingProcessor<SpringModelSearchParameters.BeanName> myBeanNameCachingProcessor = new LocalBeansCachingProcessor<SpringModelSearchParameters.BeanName>(){

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanName params, Processor<SpringBeanPointer> processor) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$2", "doProcessBeans"));
            }
            for (SpringBeanPointer beanPointer : AbstractSimpleSpringModel.this.getLocalBeans()) {
                if (!AbstractSimpleSpringModel.matchesName(params, beanPointer) || processor.process((Object)beanPointer)) continue;
                return;
            }
        }
    };

    @Override
    @NotNull
    public Collection<SpringBeanPointer> calculateDomBeans() {
        LinkedHashSet domPointers = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : this.getAllCommonBeans()) {
            if (pointer instanceof JamSpringBeanPointer) continue;
            domPointers.add(pointer);
        }
        Set<SpringBeanPointer> set = Collections.unmodifiableSet(domPointers);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "calculateDomBeans"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getAllBeanNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
        }
        SpringBeanPointer beanPointer = SpringModelSearchers.findBean(this, beanName);
        if (beanPointer == null) {
            Set<String> set = Collections.singleton(beanName);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
            }
            return set;
        }
        String[] aliases = beanPointer.getAliases();
        if (aliases.length == 0) {
            Set<String> set = Collections.singleton(beanName);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
            }
            return set;
        }
        HashSet<String> allBeanNames = new HashSet<String>(aliases.length + 1);
        allBeanNames.add(beanName);
        for (String aliasName : aliases) {
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            allBeanNames.add(aliasName);
        }
        HashSet<String> hashSet = allBeanNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
        }
        return hashSet;
    }

    @Override
    public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getDuplicatedNames"));
        }
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurers() {
        List<SpringBeanPointer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPlaceholderConfigurers"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends SpringBeansPackagesScan> getComponentScans() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getComponentScans"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
        List<SpringBeanPointer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAnnotationConfigApplicationContexts"));
        }
        return list;
    }

    @Override
    public Collection<XmlTag> getCustomBeanCandidates(String id) {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getActiveProfiles"));
        }
        return set;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByClass"));
        }
        if (!params.canSearch()) {
            return true;
        }
        if (!this.myBeanTypeCachingProcessor.process(params, processor, this.getActiveProfiles())) {
            return false;
        }
        return super.processByClass(params, processor);
    }

    private void processLocalBeans(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processLocalBeans"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processLocalBeans"));
        }
        PsiType searchType = params.getSearchType();
        if (params.isEffectiveBeanTypes()) {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                for (PsiType effectiveBeanType : beanPointer.getEffectiveBeanTypes()) {
                    if (AbstractSimpleSpringModel.processLocalBeanClass(processor, searchType, beanPointer, effectiveBeanType)) continue;
                    return;
                }
            }
        } else {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                if (AbstractSimpleSpringModel.processLocalBeanClass(processor, searchType, beanPointer, beanPointer.getSpringBean().getBeanType())) continue;
                return;
            }
        }
    }

    private static boolean processLocalBeanClass(@NotNull Processor<SpringBeanPointer> processor, @NotNull PsiType searchType, SpringBeanPointer beanPointer, @Nullable PsiType beanType) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processLocalBeanClass"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processLocalBeanClass"));
        }
        if (beanType != null && searchType.isAssignableFrom(beanType)) {
            return processor.process((Object)beanPointer);
        }
        return true;
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByName"));
        }
        if (!params.canSearch()) {
            return true;
        }
        if (!this.myBeanNameCachingProcessor.process(params, processor, this.getActiveProfiles())) {
            return false;
        }
        return super.processByName(params, processor);
    }

    private static boolean matchesName(SpringModelSearchParameters.BeanName params, SpringBeanPointer pointer) {
        String paramsBeanName = params.getBeanName();
        if (paramsBeanName.equals(pointer.getName())) {
            return true;
        }
        for (String aliasName : pointer.getAliases()) {
            if (!paramsBeanName.equals(aliasName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Set<CommonSpringModel> getPackageScanModels(@NotNull Set<? extends LocalModel> localModels, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (localModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localModels", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        for (LocalModel localModel : localModels) {
            List<? extends SpringBeansPackagesScan> scans = localModel.getComponentScans();
            for (SpringBeansPackagesScan springBeansPackagesScan : scans) {
                models.add(new SpringComponentScanModel<SpringBeansPackagesScan>(module, springBeansPackagesScan, activeProfiles));
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        return linkedHashSet;
    }

    private static abstract class LocalBeansCachingProcessor<InParams extends SpringModelSearchParameters>
    extends SpringCachingProcessor<InParams> {
        private LocalBeansCachingProcessor() {
        }

        @Override
        @NotNull
        protected Collection<SpringBeanPointer> findPointers(@NotNull InParams parameters) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$LocalBeansCachingProcessor", "findPointers"));
            }
            SmartList results = new SmartList();
            Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)results);
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer>)collectProcessor);
            SmartList smartList = results.isEmpty() ? Collections.emptyList() : results;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$LocalBeansCachingProcessor", "findPointers"));
            }
            return smartList;
        }

        @Override
        @Nullable
        protected SpringBeanPointer findFirstPointer(@NotNull InParams parameters) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel$LocalBeansCachingProcessor", "findFirstPointer"));
            }
            CommonProcessors.FindFirstProcessor firstProcessor = new CommonProcessors.FindFirstProcessor();
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer>)firstProcessor);
            return (SpringBeanPointer)firstProcessor.getFoundValue();
        }

        protected abstract void doProcessBeans(@NotNull InParams var1, Processor<SpringBeanPointer> var2);
    }
}

