/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class SpringAutodetectedFileSet
extends SpringFileSet {
    private final Icon myIcon;

    protected SpringAutodetectedFileSet(String id, String name, SpringFacet parent, Icon icon) {
        super(id, name, parent);
        this.myIcon = icon;
    }

    @Override
    public final Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public final boolean isAutodetected() {
        return true;
    }

    @Override
    protected final VirtualFilePointer createVirtualFilePointer(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/facet/SpringAutodetectedFileSet", "createVirtualFilePointer"));
        }
        return new LightFilePointer(url);
    }

    @Override
    public final void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/facet/SpringAutodetectedFileSet", "setActiveProfiles"));
        }
        super.setActiveProfiles(activeProfiles);
        ((SpringFacetConfiguration)this.getFacet().getConfiguration()).setActiveProfilesForAutodetected(this.getId(), activeProfiles);
    }
}

