/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.dom;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanInspectionBase
extends DomElementsInspection<Beans> {
    public SpringBeanInspectionBase() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        XmlFile xmlFile = domFileElement.getFile();
        Beans beans = (Beans)domFileElement.getRootElement();
        SpringModel model = SpringManager.getInstance(xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        SpringModelVisitor visitor = this.createVisitor(holder, beans, model);
        SpringModelVisitor.visitBeans(visitor, beans);
    }

    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, final @NotNull Beans beans, final @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/dom/SpringBeanInspectionBase", "createVisitor"));
        }
        return new SpringModelVisitor(){

            @Override
            protected boolean visitBean(CommonSpringBean bean) {
                if (bean instanceof SpringBean) {
                    SpringBeanInspectionBase.this.checkBean((SpringBean)bean, beans, holder, model);
                }
                return true;
            }
        };
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/dom/SpringBeanInspectionBase", "checkBean"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/dom/SpringBeanInspectionBase", "checkBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/dom/SpringBeanInspectionBase", "checkBean"));
        }
    }
}

