/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.jam.JamCustomImplementationBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringSemContributorUtil {
    private static final MultiMap<String, JamCustomImplementationBean> ourJamCustomImplementationBeans;

    private SpringSemContributorUtil() {
    }

    public static <T extends JamElement, Psi extends PsiMember> void registerMetaComponents(@NotNull SemService semService, @NotNull SemRegistrar registrar, @NotNull ElementPattern<? extends Psi> place, @NotNull SemKey<JamMemberMeta<Psi, T>> metaKey, @NotNull SemKey<T> semKey, @NotNull NullableFunction<Psi, JamMemberMeta<Psi, T>> metaFunction) {
        if (semService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semService", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerMetaComponents"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerMetaComponents"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerMetaComponents"));
        }
        if (metaKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaKey", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerMetaComponents"));
        }
        if (semKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semKey", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerMetaComponents"));
        }
        if (metaFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaFunction", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerMetaComponents"));
        }
        registrar.registerSemElementProvider(metaKey, place, metaFunction);
        registrar.registerSemElementProvider(semKey, place, member -> {
            if (semService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semService", "com/intellij/spring/model/jam/SpringSemContributorUtil", "lambda$registerMetaComponents$0"));
            }
            if (metaKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaKey", "com/intellij/spring/model/jam/SpringSemContributorUtil", "lambda$registerMetaComponents$0"));
            }
            JamMemberMeta memberMeta = (JamMemberMeta)semService.getSemElement(metaKey, (PsiElement)member);
            return memberMeta != null ? memberMeta.createJamElement(PsiElementRef.real((PsiElement)member)) : null;
        });
    }

    public static <T extends JamElement, Psi extends PsiMember> NullableFunction<Psi, JamMemberMeta<Psi, T>> createFunction(@NotNull SemKey<T> semKey, @NotNull Class<T> jamClass, @NotNull Function<Module, Collection<String>> annotationsGetter, @NotNull Function<Pair<String, Psi>, T> producer, @Nullable Consumer<JamMemberMeta<Psi, T>> metaConsumer) {
        if (semKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semKey", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        if (jamClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamClass", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        if (annotationsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsGetter", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        return SpringSemContributorUtil.createFunction(semKey, jamClass, annotationsGetter, producer, metaConsumer, null);
    }

    public static <T extends JamElement, Psi extends PsiMember> NullableFunction<Psi, JamMemberMeta<Psi, T>> createFunction(@NotNull SemKey<T> semKey, @NotNull Class<T> jamClass, @NotNull Function<Module, Collection<String>> annotationsGetter, final @NotNull Function<Pair<String, Psi>, T> producer, @Nullable Consumer<JamMemberMeta<Psi, T>> metaConsumer, @Nullable NotNullFunction<Pair<String, Project>, JamAnnotationMeta> annotationMeta) {
        if (semKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semKey", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        if (jamClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamClass", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        if (annotationsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsGetter", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/spring/model/jam/SpringSemContributorUtil", "createFunction"));
        }
        return psiMember -> {
            if (annotationsGetter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsGetter", "com/intellij/spring/model/jam/SpringSemContributorUtil", "lambda$createFunction$1"));
            }
            if (jamClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamClass", "com/intellij/spring/model/jam/SpringSemContributorUtil", "lambda$createFunction$1"));
            }
            if (semKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semKey", "com/intellij/spring/model/jam/SpringSemContributorUtil", "lambda$createFunction$1"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/spring/model/jam/SpringSemContributorUtil", "lambda$createFunction$1"));
            }
            if (DumbService.isDumb((Project)psiMember.getProject())) {
                return null;
            }
            if (psiMember instanceof PsiClass && ((PsiClass)psiMember).isAnnotationType()) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
            for (final String anno : (Collection)annotationsGetter.fun((Object)module)) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)anno, (boolean)true)) continue;
                JamMemberMeta meta = new JamMemberMeta<Psi, T>(null, jamClass, semKey){

                    public T createJamElement(PsiElementRef<Psi> psiMemberPsiRef) {
                        return (JamElement)producer.fun((Object)Pair.create((Object)anno, (Object)psiMemberPsiRef.getPsiElement()));
                    }
                };
                if (metaConsumer != null) {
                    metaConsumer.consume((Object)meta);
                }
                if (annotationMeta != null) {
                    SpringSemContributorUtil.registerCustomAnnotationMeta(anno, meta, annotationMeta, psiMember.getProject());
                }
                return meta;
            }
            return null;
        };
    }

    private static <T extends JamElement, Psi extends PsiMember> void registerCustomAnnotationMeta(@NotNull String anno, @NotNull JamMemberMeta<Psi, T> meta, @NotNull NotNullFunction<Pair<String, Project>, JamAnnotationMeta> metaNotNullFunction, @NotNull Project project) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerCustomAnnotationMeta"));
        }
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerCustomAnnotationMeta"));
        }
        if (metaNotNullFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaNotNullFunction", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerCustomAnnotationMeta"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/jam/SpringSemContributorUtil", "registerCustomAnnotationMeta"));
        }
        List annotations = meta.getAnnotations();
        for (JamAnnotationMeta annotationMeta : annotations) {
            if (!anno.equals(annotationMeta.getAnnoName())) continue;
            return;
        }
        meta.addAnnotation((JamAnnotationMeta)metaNotNullFunction.fun((Object)Pair.create((Object)anno, (Object)project)));
    }

    public static <T extends SpringStereotypeElement, Psi extends PsiMember> Consumer<JamMemberMeta<Psi, T>> createStereotypeConsumer() {
        return SpringStereotypeElement::addPomTargetProducer;
    }

    public static Function<Module, Collection<String>> getCustomMetaAnnotations(@NotNull String anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/SpringSemContributorUtil", "getCustomMetaAnnotations"));
        }
        return SpringSemContributorUtil.getCustomMetaAnnotations(anno, false);
    }

    public static Function<Module, Collection<String>> getCustomMetaAnnotations(@NotNull String anno, boolean withTests) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/SpringSemContributorUtil", "getCustomMetaAnnotations"));
        }
        return SpringSemContributorUtil.getCustomMetaAnnotations(anno, withTests, true);
    }

    public static Function<Module, Collection<String>> getCustomMetaAnnotations(final @NotNull String anno, final boolean withTests, final boolean filterCustomJamImplementations) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/SpringSemContributorUtil", "getCustomMetaAnnotations"));
        }
        return new Function<Module, Collection<String>>(){

            public Collection<String> fun(Module module) {
                if (module == null) {
                    return Collections.emptySet();
                }
                Collection<PsiClass> psiClasses = this.getAnnotationTypes(module, anno);
                Set<String> customMetaFQNs = this.getJamCustomFQNs(module);
                return ContainerUtil.mapNotNull(psiClasses, psiClass -> {
                    if (anno == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/SpringSemContributorUtil$2", "lambda$fun$0"));
                    }
                    String qualifiedName = psiClass.getQualifiedName();
                    if (anno.equals(qualifiedName)) {
                        return null;
                    }
                    if (customMetaFQNs.contains(qualifiedName)) {
                        return null;
                    }
                    return qualifiedName;
                });
            }

            @NotNull
            private Set<String> getJamCustomFQNs(Module module) {
                if (filterCustomJamImplementations && ourJamCustomImplementationBeans.containsKey((Object)anno)) {
                    SmartHashSet customMetaFQNs = new SmartHashSet();
                    Collection beans = ourJamCustomImplementationBeans.get((Object)anno);
                    for (JamCustomImplementationBean bean : beans) {
                        String customMetaAnnotationFqn = bean.customMetaAnnotationFqn;
                        customMetaFQNs.add(customMetaAnnotationFqn);
                        Collection<PsiClass> customMetaClasses = this.getAnnotationTypes(module, customMetaAnnotationFqn);
                        for (PsiClass customMetaClass : customMetaClasses) {
                            ContainerUtil.addIfNotNull((Collection)customMetaFQNs, (Object)customMetaClass.getQualifiedName());
                        }
                    }
                    SmartHashSet smartHashSet = customMetaFQNs;
                    if (smartHashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringSemContributorUtil$2", "getJamCustomFQNs"));
                    }
                    return smartHashSet;
                }
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringSemContributorUtil$2", "getJamCustomFQNs"));
                }
                return set;
            }

            private Collection<PsiClass> getAnnotationTypes(Module module, String anno2) {
                return withTests ? JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildrenIncludingTests(anno2) : JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren(anno2);
            }
        };
    }

    static {
        MultiMap beans = MultiMap.createSmart();
        for (JamCustomImplementationBean bean : (JamCustomImplementationBean[])JamCustomImplementationBean.EP_NAME.getExtensions()) {
            beans.putValue((Object)bean.baseAnnotationFqn, (Object)bean);
        }
        ourJamCustomImplementationBeans = beans;
    }
}

