/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.spring.model.jam.converters.SpringAntPatternPackageReferenceSet;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJamConverter
extends JamConverter<Collection<PsiPackage>> {
    public Collection<PsiPackage> fromString(@Nullable String s, JamStringAttributeElement<Collection<PsiPackage>> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            return null;
        }
        return this.createReferenceSet(psiLiteral, s).resolvePackage();
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<Collection<PsiPackage>> context) {
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String value = context.getStringValue();
        if (value == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = this.createReferenceSet(psiLiteral, value).getPsiReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private PackageReferenceSet createReferenceSet(@NotNull PsiLiteral psiLiteral, String value) {
        if (psiLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiLiteral", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferenceSet"));
        }
        SpringAntPatternPackageReferenceSet springAntPatternPackageReferenceSet = new SpringAntPatternPackageReferenceSet(value, (PsiElement)psiLiteral, ElementManipulators.getOffsetInElement((PsiElement)psiLiteral), SpringReferenceUtils.getResolveScope((PsiElement)psiLiteral));
        if (springAntPatternPackageReferenceSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferenceSet"));
        }
        return springAntPatternPackageReferenceSet;
    }
}

