/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.profile;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@Profile")
public class SpringJamProfile
extends CommonModelElement.PsiBase
implements SpringContextProfile {
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final PsiMember myPsiMember;
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = CONTEXT_PROFILE_JAM_ANNOTATION_KEY.subKey("SpringJamProfile", new SemKey[0]);
    private static final SemKey<SpringJamProfile> JAM_KEY = SpringContextProfile.CONTEXT_PROFILE_JAM_KEY.subKey("SpringJamProfile", new SemKey[0]);
    public static final JamMemberMeta<PsiMember, SpringJamProfile> META = new JamMemberMeta(null, SpringJamProfile.class, JAM_KEY);
    private static final JamStringAttributeMeta.Collection<String> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value");
    private static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype().addAttribute(VALUE_ATTR_META);
    public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.context.annotation.Profile", ARCHETYPE, JAM_ANNO_META_KEY);

    public SpringJamProfile(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/spring/model/jam/profile/SpringJamProfile", "<init>"));
        }
        this.myPsiMember = psiMember;
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiMember);
    }

    public SpringJamProfile(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/model/jam/profile/SpringJamProfile", "<init>"));
        }
        this.myPsiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class, (boolean)true);
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)annotation);
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        LinkedHashSet<String> profiles = new LinkedHashSet<String>();
        for (JamStringAttributeElement element : (List)ANNO_META.getAttribute((PsiModifierListOwner)this.myPsiMember, VALUE_ATTR_META)) {
            String value = (String)element.getValue();
            if (!StringUtil.isNotEmpty((String)value)) continue;
            for (String profile : StringUtil.split((String)value, (String)",")) {
                profiles.add(profile.trim());
            }
        }
        LinkedHashSet<String> linkedHashSet = profiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/profile/SpringJamProfile", "getNames"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public PsiMember getPsiElement() {
        PsiMember psiMember = this.myPsiMember;
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/profile/SpringJamProfile", "getPsiElement"));
        }
        return psiMember;
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    static {
        META.addAnnotation(ANNO_META);
    }
}

