/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.jdbc;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.testContexts.converters.PsiFileResourcePathReferenceConverter;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.jam.testContexts.jdbc.TestingSql;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringTestingSql
implements TestingSql {
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = JAM_ANNOTATION_KEY.subKey("SpringTestingSql", new SemKey[0]);
    private static final SemKey<SpringTestingSql> JAM_KEY = TestingSql.JAM_KEY.subKey("SpringTestingSql", new SemKey[0]);
    public static final JamClassMeta<SpringTestingSql> CLASS_META = new JamClassMeta(null, SpringTestingSql.class, JAM_KEY);
    public static final JamMethodMeta<SpringTestingSql> METHOD_META = new JamMethodMeta(null, SpringTestingSql.class, JAM_KEY);
    private static final JamAnnotationAttributeMeta.Single<SpringTestingSqlConfig> SQL_CONFIG_ATTR = JamAttributeMeta.singleAnno((String)"config", (JamAnnotationMeta)SpringTestingSqlConfig.ANNO_META, SpringTestingSqlConfig.class);
    public static final JamStringAttributeMeta.Collection<List<PsiFile>> SCRIPTS_ATTR_META = JamAttributeMeta.collectionString((String)"scripts", (JamConverter)new PsiFileResourcePathReferenceConverter());
    public static final JamStringAttributeMeta.Collection<List<PsiFile>> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new PsiFileResourcePathReferenceConverter());
    public static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype().addAttribute(SCRIPTS_ATTR_META).addAttribute(VALUE_ATTR_META).addAttribute(SQL_CONFIG_ATTR);
    public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.test.context.jdbc.Sql", ARCHETYPE, JAM_ANNO_META_KEY);
    private final PsiMember myPsiMember;
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    public SpringTestingSql(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/spring/model/jam/testContexts/jdbc/SpringTestingSql", "<init>"));
        }
        this.myPsiMember = psiMember;
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiMember);
    }

    public SpringTestingSql(PsiAnnotation annotation) {
        this.myPsiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class, (boolean)true);
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)annotation);
    }

    public SpringTestingSqlConfig getSqlConfig() {
        PsiAnnotationMemberValue config;
        PsiAnnotation element = (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
        if (element != null && (config = element.findDeclaredAttributeValue("config")) instanceof PsiAnnotation) {
            return (SpringTestingSqlConfig)SQL_CONFIG_ATTR.getJam(PsiElementRef.real((PsiElement)((PsiAnnotation)config)));
        }
        return null;
    }

    @Nullable
    public PsiMember getPsiElement() {
        return this.myPsiMember;
    }

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    @NotNull
    public Set<PsiFile> getScripts() {
        LinkedHashSet locations = ContainerUtil.newLinkedHashSet();
        SpringTestingSql.addFiles(locations, VALUE_ATTR_META.getJam(this.myPsiAnnotation));
        SpringTestingSql.addFiles(locations, SCRIPTS_ATTR_META.getJam(this.myPsiAnnotation));
        LinkedHashSet linkedHashSet = locations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/jdbc/SpringTestingSql", "getScripts"));
        }
        return linkedHashSet;
    }

    private static void addFiles(@NotNull Set<PsiFile> locations, @NotNull List<JamStringAttributeElement<List<PsiFile>>> jam) {
        if (locations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locations", "com/intellij/spring/model/jam/testContexts/jdbc/SpringTestingSql", "addFiles"));
        }
        if (jam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jam", "com/intellij/spring/model/jam/testContexts/jdbc/SpringTestingSql", "addFiles"));
        }
        for (JamStringAttributeElement<List<PsiFile>> element : jam) {
            List value = (List)element.getValue();
            if (value == null) continue;
            ContainerUtil.addAllNotNull(locations, (Iterable)value);
        }
    }

    static {
        CLASS_META.addAnnotation(ANNO_META);
        METHOD_META.addAnnotation(ANNO_META);
    }
}

