/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.values.SpringValueConvertersRegistry;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PropertyValueConverter
extends WrappingConverter {
    public Converter getConverter(@NotNull GenericDomValue domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/model/values/PropertyValueConverter", "getConverter"));
        }
        List<Converter> converters = this.getConverters(domElement);
        return converters.isEmpty() ? null : converters.get(0);
    }

    @NotNull
    public List<Converter> getConverters(@NotNull GenericDomValue element) {
        PsiLanguageInjectionHost host;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/PropertyValueConverter", "getConverters"));
        }
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement instanceof XmlAttribute && ((host = (PsiLanguageInjectionHost)((XmlAttribute)xmlElement).getValueElement()) == null || InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host) != null)) {
            List<Converter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PropertyValueConverter", "getConverters"));
            }
            return list;
        }
        GenericDomValueConvertersRegistry registry = SpringValueConvertersRegistry.getInstance();
        List<PsiType> types = this.getValueTypes(element);
        if (types.isEmpty()) {
            Converter converter = registry.getConverter(element, null);
            List list = ContainerUtil.createMaybeSingletonList((Object)converter);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PropertyValueConverter", "getConverters"));
            }
            return list;
        }
        SmartList converters = new SmartList();
        for (PsiType type : types) {
            Converter converter = registry.getConverter(element, type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).getComponentType() : type);
            if (converter != null) {
                converters.add(converter);
                continue;
            }
            List<Converter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PropertyValueConverter", "getConverters"));
            }
            return list;
        }
        SmartList smartList = converters;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PropertyValueConverter", "getConverters"));
        }
        return smartList;
    }

    @NotNull
    public List<PsiType> getValueTypes(GenericDomValue element) {
        List<PsiType> psiTypes;
        if (element instanceof TypeHolder && !(psiTypes = TypeHolderUtil.getRequiredTypes((TypeHolder)element)).isEmpty()) {
            List<PsiType> list = psiTypes;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PropertyValueConverter", "getValueTypes"));
            }
            return list;
        }
        DomElement parent = element.getParent();
        List<PsiType> list = parent instanceof TypeHolder ? TypeHolderUtil.getRequiredTypes((TypeHolder)parent) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PropertyValueConverter", "getValueTypes"));
        }
        return list;
    }
}

