/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.actions.BaseWebServiceIntentionAction;
import com.intellij.ws.actions.UndeployWebServiceDialog;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnExposeAsWebServiceIntention
extends BaseWebServiceIntentionAction {
    @NotNull
    public String getText() {
        String string = WSBundle.message("unexpose.class.as.web.service.dialog.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/UnExposeAsWebServiceIntention", "getText"));
        }
        return string;
    }

    @Override
    public void invoke(Project project, PsiElement element) {
        UnExposeAsWebServiceIntention.runAction(project, element, null);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/actions/UnExposeAsWebServiceIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/actions/UnExposeAsWebServiceIntention", "isAvailable"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiClass) {
            WSIndexEntry[] entries;
            PsiClass psiClass = (PsiClass)parent;
            for (WSIndexEntry entry : entries = FileBasedWSIndex.getWsEntries(psiClass)) {
                if (entry.getWsRange((PsiMember)psiClass) == null || entry.getFile() == null) continue;
                return UnExposeAsWebServiceIntention.isWebServiceClass(element);
            }
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void runAction(Project project, PsiElement element, @Nullable UndeployWebServiceDialog previousDialog) {
        UndeployWebServiceDialog dialog = new UndeployWebServiceDialog(project, previousDialog);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            PsiClass currentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            assert (currentClass != null) : element;
            dialog.preselect(module, currentClass.getName());
        }
        if (dialog.showAndGet()) {
            WSEngine currentEngine = dialog.getCurrentEngine();
            currentEngine.undeployWebService(dialog.getWSName(), dialog.getWsModule(), EmptyRunnable.getInstance(), (Consumer<Exception>)((Consumer)e -> {}), () -> UnExposeAsWebServiceIntention.runAction(dialog.getProject(), element, dialog));
        }
    }
}

