/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.WSReferenceProvider;
import org.jetbrains.annotations.NotNull;

public class EndpointReferenceProvider
extends WSReferenceProvider {
    public static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    public ElementPattern<? extends PsiElement> getPattern() {
        return PsiJavaPatterns.literalExpression().annotationParam("javax.jws.WebService", "endpointInterface");
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/EndpointReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/references/EndpointReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = CLASS_REFERENCE_PROVIDER.getReferencesByElement(element, context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/EndpointReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

