/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ws.model.jam.WSJamModel;
import com.intellij.ws.model.jam.WSJamWebService;
import com.intellij.ws.view.WSJamWebMethodFinderRecursivePanel;
import icons.WSIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSViewFinderRecursivePanel
extends FinderRecursivePanel<WSJamWebService> {
    private final Module myModule;

    public WSViewFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @NotNull Module module) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ws/view/WSViewFinderRecursivePanel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/view/WSViewFinderRecursivePanel", "<init>"));
        }
        super(parent);
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(WSJamWebService path) {
        return this.hasChildren(path) ? new WSJamWebMethodFinderRecursivePanel(this, path, this.myModule) : this.createDescriptionPanel(path);
    }

    private JComponent createDescriptionPanel(WSJamWebService path) {
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        PsiClass psiClass = path.getPsiElement();
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.myModule.getProject());
        DocumentationComponent component = new DocumentationComponent(manager);
        Disposer.register((Disposable)panel, (Disposable)component);
        manager.fetchDocInfo((PsiElement)psiClass, component);
        panel.add((Component)component, (Object)"Center");
        return panel;
    }

    private static String getDescriptionText(WSJamWebService path) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><table>");
        WSViewFinderRecursivePanel.addParameter(sb, "Class", path.getPsiElement().getQualifiedName());
        WSViewFinderRecursivePanel.addParameter(sb, "Service Name", path.getServiceName());
        WSViewFinderRecursivePanel.addParameter(sb, "Port Name", path.getPortName());
        WSViewFinderRecursivePanel.addParameter(sb, "Endpoint Interface", path.getEndpointInterface());
        WSViewFinderRecursivePanel.addParameter(sb, "Wsdl Location", path.getWsdlLocation());
        sb.append("</table></html>");
        return sb.toString();
    }

    private static void addParameter(@NotNull StringBuffer sb, @NotNull String name, @Nullable String value) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/ws/view/WSViewFinderRecursivePanel", "addParameter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/view/WSViewFinderRecursivePanel", "addParameter"));
        }
        if (value != null) {
            sb.append("<tr><td><b>");
            sb.append(name);
            sb.append(":</b></td><td>");
            sb.append(value);
            sb.append("</td></tr>");
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        WSJamWebService path = (WSJamWebService)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && path != null) {
            return path.getPsiElement();
        }
        return super.getData(dataId);
    }

    @NotNull
    protected String getItemText(WSJamWebService webService) {
        String className = StringUtil.getShortName((String)webService.getPsiElement().getQualifiedName());
        String serviceName = webService.getServiceName();
        String string = className + (serviceName == null ? "" : "(" + serviceName + ")");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/view/WSViewFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(WSJamWebService path) {
        return WSIcons.WebServicesClass;
    }

    @NotNull
    protected List<WSJamWebService> getListItems() {
        ArrayList<WSJamWebService> arrayList = new ArrayList<WSJamWebService>(WSJamModel.getModel(this.myModule).getWebServices());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/view/WSViewFinderRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    protected boolean hasChildren(WSJamWebService path) {
        return path.getWebMethods().size() > 0;
    }
}

